/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.gui.element;

import com.fantasticsource.mctools.gui.GUILeftClickEvent;
import com.fantasticsource.mctools.gui.GUIScreen;
import com.fantasticsource.mctools.gui.element.view.GUIScrollView;
import com.fantasticsource.mctools.gui.element.view.GUITooltipView;
import com.fantasticsource.tools.Tools;
import com.fantasticsource.tools.datastructures.Color;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class GUIElement {
    public static final Color T_GRAY = new Color(-1431655817);
    public static final byte AP_LEFT_TO_RIGHT_TOP_TO_BOTTOM = 0;
    public static final byte AP_RIGHT_TO_LEFT_TOP_TO_BOTTOM = 1;
    public static final byte AP_LEFT_TO_RIGHT_BOTTOM_TO_TOP = 2;
    public static final byte AP_RIGHT_TO_LEFT_BOTTOM_TO_TOP = 3;
    public static final byte AP_TOP_TO_BOTTOM_LEFT_TO_RIGHT = 4;
    public static final byte AP_TOP_TO_BOTTOM_RIGHT_TO_LEFT = 5;
    public static final byte AP_BOTTOM_TO_TOP_LEFT_TO_RIGHT = 6;
    public static final byte AP_BOTTOM_TO_TOP_RIGHT_TO_LEFT = 7;
    public static final byte AP_CENTERED_H_TOP_TO_BOTTOM = 8;
    public static final byte AP_CENTERED_V_LEFT_TO_RIGHT = 9;
    public static final byte AP_X_0_TOP_TO_BOTTOM = 10;
    public final ArrayList<Runnable> onClickActions = new ArrayList();
    public final ArrayList<Runnable> onRecalcActions = new ArrayList();
    public final ArrayList<Runnable> onEditActions = new ArrayList();
    public double x;
    public double y;
    public double width;
    public double height;
    public GUIElement parent = null;
    public ArrayList<GUIElement> children = new ArrayList();
    public GUITooltipView tooltip = null;
    public boolean autoplace = false;
    protected double autoX = 0.0;
    protected double autoY = 0.0;
    protected double furthestX = 0.0;
    protected double furthestY = 0.0;
    protected byte subElementAutoplaceMethod;
    protected GUIScreen screen;
    protected boolean active = false;
    protected boolean externalDeactivation = false;
    private ArrayList<GUIElement> linkedMouseActivity = new ArrayList();
    private ArrayList<GUIElement> linkedMouseActivityReverse = new ArrayList();

    public GUIElement(GUIScreen screen, double width, double height) {
        this(screen, width, height, 0);
    }

    public GUIElement(GUIScreen screen, double width, double height, byte subElementAutoplaceMethod) {
        this(screen, 0.0, 0.0, width, height, subElementAutoplaceMethod);
        this.autoplace = true;
    }

    public GUIElement(GUIScreen screen, double x, double y, double width, double height) {
        this(screen, x, y, width, height, 0);
    }

    public GUIElement(GUIScreen screen, double x, double y, double width, double height, byte subElementAutoplaceMethod) {
        this.screen = screen;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.subElementAutoplaceMethod = subElementAutoplaceMethod;
    }

    public GUIElement setTooltip(String tooltip) {
        if (tooltip == null || tooltip.trim().equals("")) {
            this.tooltip = null;
            return this;
        }
        if (this.tooltip == null) {
            this.tooltip = new GUITooltipView(this.screen);
        }
        this.tooltip.setTooltip(tooltip);
        return this;
    }

    public boolean isWithin(double x, double y) {
        double xx = this.absoluteX();
        double yy = this.absoluteY();
        return xx <= x && x < xx + this.absoluteWidth() && yy <= y && y < yy + this.absoluteHeight();
    }

    protected int[] preDraw() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)this.x, (double)this.y, (double)0.0);
        GlStateManager.func_179139_a((double)this.width, (double)this.height, (double)1.0);
        int[] lastScissor = new int[4];
        System.arraycopy(GUIScreen.currentScissor, 0, lastScissor, 0, 4);
        GUIScreen.currentScissor[0] = Tools.max(GUIScreen.currentScissor[0], this.absolutePxX());
        GUIScreen.currentScissor[1] = Tools.max(GUIScreen.currentScissor[1], this.absolutePxY());
        GUIScreen.currentScissor[2] = Tools.min(GUIScreen.currentScissor[2], this.absolutePxX() + this.absolutePxWidth());
        GUIScreen.currentScissor[3] = Tools.min(GUIScreen.currentScissor[3], this.absolutePxY() + this.absolutePxHeight());
        if (!this.screen.scissor()) {
            GUIScreen.currentScissor = lastScissor;
            GlStateManager.func_179121_F();
            return null;
        }
        return lastScissor;
    }

    protected final void drawChildren() {
        if (this.children.size() > 0 && this.width > 0.0 && this.height > 0.0) {
            for (GUIElement element : this.children.toArray(new GUIElement[0])) {
                int[] lastScissor = element.preDraw();
                if (lastScissor == null) continue;
                element.draw();
                element.postDraw(lastScissor);
            }
        }
        if (this.isMouseWithin() && this.tooltip != null) {
            this.screen.tooltips.add(this.tooltip);
        }
    }

    private void postDraw(int[] lastScissor) {
        GUIScreen.currentScissor = lastScissor;
        GlStateManager.func_179121_F();
    }

    public void draw() {
        this.drawChildren();
    }

    public void mouseWheel(double x, double y, int delta) {
        for (GUIElement child : (ArrayList)this.children.clone()) {
            child.mouseWheel(x - this.x, y - this.y, delta);
        }
    }

    public boolean mousePressed(double x, double y, int button) {
        if (button == 0 && this.isMouseWithin()) {
            this.setActive(true);
        }
        for (GUIElement child : (ArrayList)this.children.clone()) {
            child.mousePressed(x - this.x, y - this.y, button);
        }
        return this.active;
    }

    public boolean mouseReleased(double x, double y, int button) {
        boolean result = false;
        if (button == 0) {
            if (this.active && this.isMouseWithin()) {
                if (!MinecraftForge.EVENT_BUS.post((Event)new GUILeftClickEvent(this.screen, this))) {
                    this.click();
                }
                result = true;
            }
            this.setActive(false);
        }
        for (GUIElement child : (ArrayList)this.children.clone()) {
            child.mouseReleased(x - this.x, y - this.y, button);
        }
        return result;
    }

    public void click() {
        for (Runnable action : this.onClickActions) {
            action.run();
        }
    }

    public GUIElement addClickActions(Runnable ... actions) {
        this.onClickActions.addAll(Arrays.asList(actions));
        return this;
    }

    public GUIElement addRecalcActions(Runnable ... actions) {
        this.onRecalcActions.addAll(Arrays.asList(actions));
        return this;
    }

    public GUIElement addEditActions(Runnable ... actions) {
        this.onEditActions.addAll(Arrays.asList(actions));
        return this;
    }

    public void mouseDrag(double x, double y, int button) {
        for (GUIElement child : (ArrayList)this.children.clone()) {
            child.mouseDrag(x - this.x, y - this.y, button);
        }
    }

    public final double absoluteX() {
        if (this.parent == null) {
            return this.x;
        }
        return this.parent.absoluteX() + this.x * this.parent.absoluteWidth();
    }

    public final double absoluteY() {
        if (this.parent == null) {
            return this.y;
        }
        if (this.parent instanceof GUIScrollView) {
            return this.parent.absoluteY() + (this.y - ((GUIScrollView)this.parent).top) * this.parent.absoluteHeight();
        }
        return this.parent.absoluteY() + this.y * this.parent.absoluteHeight();
    }

    public final int absolutePxX() {
        return (int)Math.round(this.absoluteX() * (double)this.screen.pxWidth);
    }

    public final int absolutePxY() {
        return (int)Math.round(this.absoluteY() * (double)this.screen.pxHeight);
    }

    public final double absoluteWidth() {
        if (this.parent == null) {
            return this.width;
        }
        return this.parent.absoluteWidth() * this.width;
    }

    public final double absoluteHeight() {
        if (this.parent == null) {
            return this.height;
        }
        return this.parent.absoluteHeight() * this.height;
    }

    public final int absolutePxWidth() {
        return (int)Math.round(this.absoluteWidth() * (double)this.screen.pxWidth);
    }

    public final int absolutePxHeight() {
        return (int)Math.round(this.absoluteHeight() * (double)this.screen.pxHeight);
    }

    public final double mouseX() {
        return GUIScreen.mouseX;
    }

    public final double mouseY() {
        return GUIScreen.mouseY;
    }

    public final boolean isMouseWithin() {
        for (GUIElement element : this.linkedMouseActivityReverse) {
            if (!element.isWithin(this.mouseX(), this.mouseY())) continue;
            return true;
        }
        return this.isWithin(this.mouseX(), this.mouseY()) && (this.parent == null || this.parent.isMouseWithin());
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public GUIElement recalc(int subIndexChanged) {
        this.recalcAndRepositionSubElements(subIndexChanged);
        this.postRecalc();
        return this;
    }

    public final void postRecalc() {
        for (Runnable action : this.onRecalcActions) {
            action.run();
        }
    }

    public GUIElement add(GUIElement element) {
        element.parent = this;
        this.children.add(element);
        this.recalc(this.size() - 1);
        return element;
    }

    public GUIElement addAll(GUIElement ... elements) {
        for (GUIElement element : elements) {
            this.add(element);
        }
        return this;
    }

    public GUIElement add(int index, GUIElement element) {
        element.parent = this;
        this.children.add(index, element);
        this.recalc(index);
        return element;
    }

    public void recalcAndRepositionSubElements(int startIndex) {
        switch (this.subElementAutoplaceMethod) {
            case 0: {
                GUIElement element;
                int i;
                if (this.size() <= 1 || startIndex != this.size() - 1) {
                    this.autoX = 0.0;
                    this.autoY = 0.0;
                    this.furthestX = 0.0;
                    this.furthestY = 0.0;
                    for (i = 0; i < startIndex; ++i) {
                        element = this.get(i);
                        if (!element.autoplace) continue;
                        this.autoX = element.x + element.width;
                        this.autoY = element.y;
                        this.furthestX = Tools.max(this.furthestX, this.autoX);
                        this.furthestY = Tools.max(this.furthestY, this.autoY + element.height);
                    }
                }
                for (i = startIndex; i < this.size(); ++i) {
                    element = this.get(i);
                    element.recalc(0);
                    if (!element.autoplace) continue;
                    if (this.autoX != 0.0 && this.autoX + element.width > 1.0) {
                        element.x = 0.0;
                        element.y = this.furthestY;
                    } else {
                        element.x = this.autoX;
                        element.y = this.autoY;
                    }
                    this.autoX = element.x + element.width;
                    this.autoY = element.y;
                    this.furthestX = Tools.max(this.furthestX, this.autoX);
                    this.furthestY = Tools.max(this.furthestY, this.autoY + element.height);
                }
                break;
            }
            case 8: {
                GUIElement element;
                int i;
                if (this.size() <= 1 || startIndex != this.size() - 1) {
                    this.autoY = 0.0;
                    this.furthestY = 0.0;
                    for (i = 0; i < startIndex; ++i) {
                        element = this.get(i);
                        if (!element.autoplace) continue;
                        this.autoY = element.y;
                        this.furthestY = Tools.max(this.furthestY, this.autoY + element.height);
                    }
                }
                for (i = startIndex; i < this.size(); ++i) {
                    element = this.get(i);
                    element.recalc(0);
                    if (!element.autoplace) continue;
                    element.x = 0.5 - element.width / 2.0;
                    this.autoY = element.y = this.furthestY;
                    this.furthestY = Tools.max(this.furthestY, this.autoY + element.height);
                }
                break;
            }
            case 10: {
                GUIElement element;
                int i;
                if (this.size() <= 1 || startIndex != this.size() - 1) {
                    this.autoY = 0.0;
                    this.furthestY = 0.0;
                    for (i = 0; i < startIndex; ++i) {
                        element = this.get(i);
                        if (!element.autoplace) continue;
                        this.autoY = element.y;
                        this.furthestY = Tools.max(this.furthestY, this.autoY + element.height);
                    }
                }
                for (i = startIndex; i < this.size(); ++i) {
                    element = this.get(i);
                    element.recalc(0);
                    if (!element.autoplace) continue;
                    element.x = 0.0;
                    this.autoY = element.y = this.furthestY;
                    this.furthestY = Tools.max(this.furthestY, this.autoY + element.height);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unimplemented autoplace type: " + this.subElementAutoplaceMethod);
            }
        }
    }

    public void setSubElementAutoplaceMethod(byte subElementAutoplaceMethod) {
        this.subElementAutoplaceMethod = subElementAutoplaceMethod;
        this.recalc(0);
    }

    public void remove(GUIElement element) {
        int index = this.indexOf(element);
        if (element.parent == this) {
            element.parent = null;
        }
        if (index != -1) {
            this.remove(index);
        }
    }

    public void remove(int index) {
        GUIElement element = this.children.remove(index);
        if (element.parent == this) {
            element.parent = null;
        }
        this.recalc(Tools.max(0, index - 1));
    }

    public int size() {
        return this.children.size();
    }

    public void clear() {
        for (GUIElement child : (ArrayList)this.children.clone()) {
            if (child.parent != this) continue;
            child.parent = null;
        }
        this.children.clear();
        this.recalc(0);
    }

    public GUIElement get(int index) {
        return this.children.get(index);
    }

    public int indexOf(GUIElement child) {
        int i = 0;
        for (GUIElement element : this.children) {
            if (element == child) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void linkMouseActivity(GUIElement element) {
        this.linkedMouseActivity.add(element);
        element.linkedMouseActivityReverse.add(this);
    }

    public void unlinkMouseActivity(GUIElement element) {
        this.linkedMouseActivity.remove(element);
        element.linkedMouseActivityReverse.remove(this);
    }

    public void setExternalDeactivation(boolean external, boolean recursive) {
        this.externalDeactivation = external;
        if (recursive) {
            for (GUIElement child : this.children) {
                child.setExternalDeactivation(external, true);
            }
        }
    }

    public void setActive(boolean active) {
        this.setActive(active, false);
    }

    public void setActive(boolean active, boolean external) {
        if (!active && this.externalDeactivation && !external) {
            return;
        }
        this.active = active;
        for (GUIElement element : this.linkedMouseActivity) {
            element.active = active;
        }
    }

    public void setActiveRecursive(boolean active) {
        this.setActive(active, true);
        for (GUIElement child : this.children) {
            child.setActiveRecursive(active);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void keyTyped(char typedChar, int keyCode) {
        for (GUIElement child : (ArrayList)this.children.clone()) {
            child.keyTyped(typedChar, keyCode);
        }
    }
}

