/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.event;

import com.fantasticsource.mctools.GlobalInventory;
import com.fantasticsource.mctools.items.ItemMatcher;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class InventoryChangedEvent
extends EntityEvent {
    public static LinkedHashMap<Entity, ArrayList<ItemStack>> previousContents = new LinkedHashMap();
    public ArrayList<ItemStack> oldInventory;
    public ArrayList<ItemStack> newInventory;

    public InventoryChangedEvent(Entity entity, ArrayList<ItemStack> oldInventory, ArrayList<ItemStack> newInventory) {
        super(entity);
        this.oldInventory = oldInventory;
        this.newInventory = newInventory;
    }

    @SubscribeEvent
    public static void worldTick(TickEvent.WorldTickEvent event) {
        if (event.side == Side.CLIENT || event.phase == TickEvent.Phase.END) {
            return;
        }
        previousContents.entrySet().removeIf(entry -> {
            Entity entity = (Entity)entry.getKey();
            if (!entity.isAddedToWorld()) {
                return true;
            }
            for (WorldServer world : FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
                if (world != event.world) continue;
                return false;
            }
            return true;
        });
        for (Entity entity : event.world.field_72996_f) {
            if (!entity.isAddedToWorld()) {
                previousContents.remove(entity);
                continue;
            }
            ArrayList<ItemStack> newInventory = GlobalInventory.getAllNonAWItems(entity);
            ArrayList<ItemStack> oldInventory = previousContents.getOrDefault(entity, new ArrayList());
            if (newInventory.size() != oldInventory.size()) {
                MinecraftForge.EVENT_BUS.post((Event)new InventoryChangedEvent((Entity)((EntityLivingBase)entity), oldInventory, newInventory));
                previousContents.put(entity, newInventory);
                continue;
            }
            boolean match = true;
            for (int i = 0; i < newInventory.size(); ++i) {
                if (ItemMatcher.stacksMatch(oldInventory.get(i), newInventory.get(i))) continue;
                match = false;
                break;
            }
            if (match) continue;
            MinecraftForge.EVENT_BUS.post((Event)new InventoryChangedEvent((Entity)((EntityLivingBase)entity), oldInventory, newInventory));
            previousContents.put(entity, newInventory);
        }
    }

    static {
        MinecraftForge.EVENT_BUS.register(InventoryChangedEvent.class);
    }
}

