/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.aw;

import com.fantasticsource.mctools.GlobalInventory;
import com.fantasticsource.mctools.aw.RenderModes;
import com.fantasticsource.mctools.event.InventoryChangedEvent;
import com.fantasticsource.tools.datastructures.Color;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TransientAWSkinHandler {
    @GameRegistry.ObjectHolder(value="armourers_workshop:item.skin")
    public static Item awSkinItem;

    public static void addTransientAWSkin(ItemStack stack, String libraryFile, String skinType, Color ... dyes) {
        TransientAWSkinHandler.addTransientAWSkin(stack, libraryFile, skinType, null, null, dyes);
    }

    public static void addTransientAWSkin(ItemStack stack, String libraryFile, String skinType, String renderChannel, String renderMode, Color ... dyes) {
        NBTTagCompound compound;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!(compound = stack.func_77978_p()).func_74764_b("flib")) {
            compound.func_74782_a("flib", (NBTBase)new NBTTagCompound());
        }
        if (!(compound = compound.func_74775_l("flib")).func_74764_b("AWSkins")) {
            compound.func_74782_a("AWSkins", (NBTBase)new NBTTagList());
        }
        NBTTagList list = compound.func_150295_c("AWSkins", 10);
        compound = new NBTTagCompound();
        list.func_74742_a((NBTBase)compound);
        compound.func_74778_a("file", libraryFile.replace(".armour", ""));
        compound.func_74778_a("type", skinType);
        if (renderChannel != null && renderMode != null) {
            compound.func_74778_a("renderChannel", renderChannel);
            compound.func_74778_a("renderMode", renderMode);
        }
        if (dyes.length > 0) {
            list = new NBTTagList();
            compound.func_74782_a("dyes", (NBTBase)list);
            for (Color dye : dyes) {
                list.func_74742_a((NBTBase)new NBTTagInt(dye.color()));
            }
        }
    }

    public static void clearTransientAWSkins(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagCompound mainTag = stack.func_77978_p();
        if (!mainTag.func_74764_b("flib")) {
            return;
        }
        NBTTagCompound compound = mainTag.func_74775_l("flib");
        compound.func_82580_o("AWSkins");
        if (compound.func_82582_d()) {
            mainTag.func_82580_o("flib");
            if (mainTag.func_82582_d()) {
                stack.func_77982_d(null);
            }
        }
    }

    private static void applyNBTToTransientSkin(ItemStack stack, String libraryFile, String skinType, Color ... dyes) {
        NBTTagCompound compound;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!(compound = stack.func_77978_p()).func_74764_b("flib")) {
            compound.func_74782_a("flib", (NBTBase)new NBTTagCompound());
        }
        compound = compound.func_74775_l("flib");
        compound.func_74757_a("awTransient", true);
        compound = new NBTTagCompound();
        stack.func_77978_p().func_74782_a("armourersWorkshop", (NBTBase)compound);
        NBTTagCompound compound2 = new NBTTagCompound();
        compound.func_74782_a("identifier", (NBTBase)compound2);
        compound2.func_74778_a("libraryFile", libraryFile);
        compound2.func_74778_a("skinType", skinType);
        compound2 = new NBTTagCompound();
        compound.func_74782_a("dyeData", (NBTBase)compound2);
        int i = 0;
        for (Color color : dyes) {
            compound2.func_74774_a("dye" + i + "r", (byte)color.r());
            compound2.func_74774_a("dye" + i + "g", (byte)color.g());
            compound2.func_74774_a("dye" + i + "b", (byte)color.b());
            compound2.func_74774_a("dye" + i + "t", (byte)color.a());
            ++i;
        }
    }

    public static boolean isTransientSkin(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return false;
        }
        NBTTagCompound compound = stack.func_77978_p();
        if (!compound.func_74764_b("flib")) {
            return false;
        }
        return compound.func_74775_l("flib").func_74767_n("awTransient");
    }

    public static void tryApplyTransientSkinsFromStack(ItemStack stack, Entity target) {
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagCompound compound = stack.func_77978_p();
        if (!compound.func_74764_b("flib")) {
            return;
        }
        if (!(compound = compound.func_74775_l("flib")).func_74764_b("AWSkins")) {
            return;
        }
        NBTTagList list = compound.func_150295_c("AWSkins", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ItemStack newSkin;
            String targetRenderMode;
            compound = list.func_150305_b(i);
            if (compound.func_74764_b("renderChannel") && ((targetRenderMode = RenderModes.getRenderMode(target, compound.func_74779_i("renderChannel"))) == null && compound.func_74764_b("renderMode") || !compound.func_74779_i("renderMode").equals(targetRenderMode))) continue;
            ArrayList<Color> dyes = new ArrayList<Color>();
            if (compound.func_74764_b("dyes")) {
                NBTTagList list2 = compound.func_150295_c("dyes", 3);
                for (int i2 = 0; i2 < list2.func_74745_c(); ++i2) {
                    dyes.add(new Color(list2.func_186858_c(i2)));
                }
            }
            String skinType = compound.func_74779_i("type");
            int size = GlobalInventory.getAWSkinSlotCount(target, skinType);
            int transientSkinAt = -1;
            for (int i2 = 0; i2 < size; ++i2) {
                ItemStack oldSkin = GlobalInventory.getAWSkin(target, skinType, i2);
                if (oldSkin.func_190926_b()) {
                    newSkin = new ItemStack(awSkinItem);
                    TransientAWSkinHandler.applyNBTToTransientSkin(newSkin, compound.func_74779_i("file"), skinType, dyes.toArray(new Color[0]));
                    GlobalInventory.setAWSkin(target, skinType, i2, newSkin);
                    transientSkinAt = -1;
                    break;
                }
                if (transientSkinAt != -1 || !TransientAWSkinHandler.isTransientSkin(oldSkin)) continue;
                transientSkinAt = i2;
            }
            if (transientSkinAt < 0) continue;
            newSkin = new ItemStack(awSkinItem);
            TransientAWSkinHandler.applyNBTToTransientSkin(newSkin, compound.func_74779_i("file"), skinType, dyes.toArray(new Color[0]));
            GlobalInventory.setAWSkin(target, skinType, transientSkinAt, newSkin);
        }
    }

    public static void removeAllTransientSkins(Entity entity) {
        for (ItemStack skin : GlobalInventory.getAWSkins(entity)) {
            if (!TransientAWSkinHandler.isTransientSkin(skin)) continue;
            skin.func_77982_d(null);
            skin.func_190920_e(0);
        }
    }

    @SubscribeEvent
    public static void inventoryChanged(InventoryChangedEvent event) {
        TransientAWSkinHandler.refresh(event.getEntity());
    }

    public static void refresh(Entity entity) {
        TransientAWSkinHandler.removeAllTransientSkins(entity);
        for (ItemStack stack : GlobalInventory.getAllEquippedItems(entity)) {
            TransientAWSkinHandler.tryApplyTransientSkinsFromStack(stack, entity);
        }
        GlobalInventory.syncAWWardrobeSkins(entity, true, true);
    }
}

