/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools;

import com.fantasticsource.mctools.MCTools;
import com.fantasticsource.tools.ReflectionTool;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class WorldEventDistributor
implements IWorldEventListener {
    private static Field worldEventListenersField = ReflectionTool.getField(World.class, "field_73021_x", "eventListeners");
    private World world;
    private List<IWorldEventListener> normalListeners = new ArrayList<IWorldEventListener>();

    private WorldEventDistributor(World world, List<IWorldEventListener> originalListeners) {
        this.world = world;
        this.normalListeners.addAll(originalListeners);
        originalListeners.clear();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void worldLoad(WorldEvent.Load event) {
        try {
            World world = event.getWorld();
            List originalListeners = (List)worldEventListenersField.get(world);
            originalListeners.add(0, new WorldEventDistributor(world, originalListeners));
        }
        catch (IllegalAccessException e) {
            MCTools.crash(e, 703, true);
        }
    }

    public void func_184376_a(World world, BlockPos pos, IBlockState oldState, IBlockState newState, int flags) {
        DBlockUpdateEvent event = new DBlockUpdateEvent(world, pos, oldState, newState, flags);
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            for (IWorldEventListener listener : this.normalListeners) {
                listener.func_184376_a(event.getWorld(), event.pos, event.oldState, event.newState, event.flags);
            }
        }
    }

    public void func_174959_b(BlockPos pos) {
        DNotifyLightSetEvent event = new DNotifyLightSetEvent(this.world, pos);
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            for (IWorldEventListener listener : this.normalListeners) {
                listener.func_174959_b(event.pos);
            }
        }
    }

    public void func_147585_a(int x1, int y1, int z1, int x2, int y2, int z2) {
        DMarkBlockRangeForRenderUpdateEvent event = new DMarkBlockRangeForRenderUpdateEvent(this.world, x1, y1, z1, x2, y2, z2);
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            for (IWorldEventListener listener : this.normalListeners) {
                listener.func_147585_a(event.x1, event.y1, event.z1, event.x2, event.y2, event.z2);
            }
        }
    }

    public void func_184375_a(@Nullable EntityPlayer player, SoundEvent soundEvent, SoundCategory soundCategory, double x, double y, double z, float volume, float pitch) {
        DSoundEvent event = new DSoundEvent(this.world, player, soundEvent, soundCategory, x, y, z, volume, pitch);
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            for (IWorldEventListener listener : this.normalListeners) {
                listener.func_184375_a(event.player, event.soundEvent, event.soundCategory, event.x, event.y, event.z, event.volume, event.pitch);
            }
        }
    }

    public void func_184377_a(SoundEvent soundEvent, BlockPos pos) {
        DPlayRecordEvent event = new DPlayRecordEvent(this.world, soundEvent, pos);
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            for (IWorldEventListener listener : this.normalListeners) {
                listener.func_184377_a(event.soundEvent, event.pos);
            }
        }
    }

    public void func_180442_a(int particleID, boolean ignoreRange, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        this.func_190570_a(particleID, ignoreRange, false, x, y, z, xSpeed, ySpeed, zSpeed, parameters);
    }

    public void func_190570_a(int id, boolean ignoreRange, boolean minimumParticles, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        DSpawnParticleEvent event = new DSpawnParticleEvent(this.world, id, ignoreRange, minimumParticles, x, y, z, xSpeed, ySpeed, zSpeed, parameters);
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            for (IWorldEventListener listener : this.normalListeners) {
                listener.func_190570_a(event.id, event.ignoreRange, event.minimumParticles, event.x, event.y, event.z, event.xSpeed, event.ySpeed, event.zSpeed, event.parameters);
            }
        }
    }

    public void func_72703_a(Entity entity) {
        MinecraftForge.EVENT_BUS.post((Event)new DEntityAddedEvent(this.world, entity));
        for (IWorldEventListener listener : this.normalListeners) {
            listener.func_72703_a(entity);
        }
    }

    public void func_72709_b(Entity entity) {
        MinecraftForge.EVENT_BUS.post((Event)new DEntityRemovedEvent(this.world, entity));
        for (IWorldEventListener listener : this.normalListeners) {
            listener.func_72709_b(entity);
        }
    }

    public void func_180440_a(int soundID, BlockPos pos, int data) {
        DBroadcastSoundEvent event = new DBroadcastSoundEvent(this.world, soundID, pos, data);
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            for (IWorldEventListener listener : this.normalListeners) {
                listener.func_180440_a(event.soundID, event.pos, event.data);
            }
        }
    }

    public void func_180439_a(EntityPlayer player, int type, BlockPos pos, int data) {
        DPlayEvent event = new DPlayEvent(this.world, player, type, pos, data);
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            for (IWorldEventListener listener : this.normalListeners) {
                listener.func_180439_a(event.player, event.type, event.pos, event.data);
            }
        }
    }

    public void func_180441_b(int breakerID, BlockPos pos, int progress) {
        DSendBlockBreakProgressEvent event = new DSendBlockBreakProgressEvent(this.world, breakerID, pos, progress);
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            for (IWorldEventListener listener : this.normalListeners) {
                listener.func_180441_b(event.breakerID, event.pos, event.progress);
            }
        }
    }

    @Cancelable
    public static class DSendBlockBreakProgressEvent
    extends DWorldEvent {
        public int breakerID;
        public int progress;
        public BlockPos pos;

        private DSendBlockBreakProgressEvent(World world, int breakerID, BlockPos pos, int progress) {
            super(world);
            this.breakerID = breakerID;
            this.pos = pos;
            this.progress = progress;
        }
    }

    @Cancelable
    public static class DPlayEvent
    extends DWorldEvent {
        public EntityPlayer player;
        public int type;
        public int data;
        public BlockPos pos;

        private DPlayEvent(World world, EntityPlayer player, int type, BlockPos pos, int data) {
            super(world);
            this.player = player;
            this.type = type;
            this.pos = pos;
            this.data = data;
        }
    }

    @Cancelable
    public static class DBroadcastSoundEvent
    extends DWorldEvent {
        public int soundID;
        public int data;
        public BlockPos pos;

        private DBroadcastSoundEvent(World world, int soundID, BlockPos pos, int data) {
            super(world);
            this.soundID = soundID;
            this.pos = pos;
            this.data = data;
        }
    }

    public static class DEntityRemovedEvent
    extends DWorldEvent {
        private Entity entity;

        private DEntityRemovedEvent(World world, Entity entity) {
            super(world);
            this.entity = entity;
        }

        public Entity getEntity() {
            return this.entity;
        }
    }

    public static class DEntityAddedEvent
    extends DWorldEvent {
        private Entity entity;

        private DEntityAddedEvent(World world, Entity entity) {
            super(world);
            this.entity = entity;
        }

        public Entity getEntity() {
            return this.entity;
        }
    }

    @Cancelable
    public static class DSpawnParticleEvent
    extends DWorldEvent {
        public int id;
        public boolean ignoreRange;
        public boolean minimumParticles;
        public double x;
        public double y;
        public double z;
        public double xSpeed;
        public double ySpeed;
        public double zSpeed;
        public int[] parameters;

        private DSpawnParticleEvent(World world, int id, boolean ignoreRange, boolean minimumParticles, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
            super(world);
            this.id = id;
            this.ignoreRange = ignoreRange;
            this.minimumParticles = minimumParticles;
            this.x = x;
            this.y = y;
            this.z = z;
            this.xSpeed = xSpeed;
            this.ySpeed = ySpeed;
            this.zSpeed = zSpeed;
            this.parameters = parameters;
        }
    }

    @Cancelable
    public static class DPlayRecordEvent
    extends DWorldEvent {
        public SoundEvent soundEvent;
        public BlockPos pos;

        private DPlayRecordEvent(World world, SoundEvent soundEvent, BlockPos pos) {
            super(world);
            this.soundEvent = soundEvent;
            this.pos = pos;
        }
    }

    @Cancelable
    public static class DSoundEvent
    extends DWorldEvent {
        public EntityPlayer player;
        public SoundEvent soundEvent;
        public SoundCategory soundCategory;
        public double x;
        public double y;
        public double z;
        public float volume;
        public float pitch;
        public Entity entity = null;

        private DSoundEvent(World world, @Nullable EntityPlayer player, SoundEvent soundEvent, SoundCategory soundCategory, double x, double y, double z, float volume, float pitch) {
            super(world);
            this.player = player;
            this.soundEvent = soundEvent;
            this.soundCategory = soundCategory;
            this.x = x;
            this.y = y;
            this.z = z;
            this.volume = volume;
            this.pitch = pitch;
            for (Entity entity : world.field_72996_f) {
                if (entity.field_70165_t != x || entity.field_70163_u != y || entity.field_70161_v != z) continue;
                this.entity = entity;
                break;
            }
        }
    }

    @Cancelable
    public static class DMarkBlockRangeForRenderUpdateEvent
    extends DWorldEvent {
        public int x1;
        public int y1;
        public int z1;
        public int x2;
        public int y2;
        public int z2;

        private DMarkBlockRangeForRenderUpdateEvent(World world, int x1, int y1, int z1, int x2, int y2, int z2) {
            super(world);
            this.x1 = x1;
            this.y1 = y1;
            this.z1 = z1;
            this.x2 = x2;
            this.y2 = y2;
            this.z2 = z2;
        }
    }

    @Cancelable
    public static class DNotifyLightSetEvent
    extends DWorldEvent {
        public BlockPos pos;

        private DNotifyLightSetEvent(World world, BlockPos pos) {
            super(world);
            this.pos = pos;
        }
    }

    @Cancelable
    public static class DBlockUpdateEvent
    extends DWorldEvent {
        public BlockPos pos;
        public IBlockState oldState;
        public IBlockState newState;
        public int flags;

        private DBlockUpdateEvent(World world, BlockPos pos, IBlockState oldState, IBlockState newState, int flags) {
            super(world);
            this.pos = pos;
            this.oldState = oldState;
            this.newState = newState;
            this.flags = flags;
        }
    }

    public static class DWorldEvent
    extends Event {
        private World world;

        public DWorldEvent(World world) {
            this.world = world;
        }

        public World getWorld() {
            return this.world;
        }
    }
}

