/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class PlayerData {
    public static LinkedHashMap<UUID, PlayerData> playerData = new LinkedHashMap();
    private static String modDir = Loader.instance().getConfigDir().getAbsolutePath() + File.separator + "fantasticlib" + File.separator;
    private static String referenceDir = modDir + "reference" + File.separator;
    public String name;
    public UUID id;
    public EntityPlayer player;

    public PlayerData(String name, UUID id) {
        this(name, id, null);
    }

    public PlayerData(String name, UUID id, EntityPlayer player) {
        this.name = name;
        this.id = id;
        this.player = player;
    }

    public static PlayerData get(UUID id) {
        PlayerData result = playerData.get(id);
        if (result != null) {
            if (result.player != null && !result.player.func_70005_c_().equals(result.name)) {
                result.name = result.player.func_70005_c_();
            }
            return result;
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            return null;
        }
        PlayerList playerList = server.func_184103_al();
        if (playerList == null) {
            return null;
        }
        EntityPlayerMP player = playerList.func_177451_a(id);
        if (player == null) {
            return null;
        }
        result = new PlayerData(player.func_70005_c_(), player.getPersistentID(), (EntityPlayer)player);
        playerData.put(id, result);
        return result;
    }

    public static PlayerData get(String name) {
        PlayerData result;
        for (Map.Entry<UUID, PlayerData> entry : playerData.entrySet()) {
            result = entry.getValue();
            if (!result.name.equals(name)) continue;
            return result;
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            return null;
        }
        PlayerList playerList = server.func_184103_al();
        if (playerList == null) {
            return null;
        }
        EntityPlayerMP player = playerList.func_152612_a(name);
        if (player == null) {
            return null;
        }
        result = new PlayerData(player.func_70005_c_(), player.getPersistentID(), (EntityPlayer)player);
        playerData.put(player.getPersistentID(), result);
        return result;
    }

    public static String getName(UUID id) {
        PlayerData data = PlayerData.get(id);
        return data == null ? null : data.name;
    }

    public static UUID getID(String name) {
        PlayerData data = PlayerData.get(name);
        return data == null ? null : data.id;
    }

    public static void save() {
        File file = new File(modDir);
        if (!file.exists()) {
            file.mkdir();
        }
        if (!(file = new File(referenceDir)).exists()) {
            file.mkdir();
        }
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(new File(referenceDir + "players.txt")));
            for (UUID id : playerData.keySet()) {
                PlayerData data = PlayerData.get(id);
                if (data == null || data.name == null) continue;
                writer.write(id + " = " + data.name + "\r\n");
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void load() {
        File file = new File(modDir);
        if (!file.exists()) {
            file.mkdir();
        }
        if (!(file = new File(referenceDir)).exists()) {
            file.mkdir();
        }
        if (!(file = new File(referenceDir + "players.txt")).exists()) {
            PlayerData.save();
            return;
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = reader.readLine();
            while (line != null && !line.trim().equals("")) {
                String[] tokens = line.split("=");
                UUID id = UUID.fromString(tokens[0].trim());
                playerData.put(id, new PlayerData(tokens[1].trim(), id));
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void playerLogon(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            playerData.put(player.getPersistentID(), new PlayerData(player.func_70005_c_(), player.getPersistentID(), (EntityPlayer)player));
            PlayerData.save();
        }
    }

    @SubscribeEvent
    public static void playerLogoff(PlayerEvent.PlayerLoggedOutEvent event) {
        UUID id;
        if (event.player != null && playerData.containsKey(id = event.player.getPersistentID())) {
            PlayerData.playerData.get((Object)id).player = null;
        }
    }
}

