/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools;

import com.fantasticsource.mctools.component.CResourceLocation;
import com.fantasticsource.mctools.controlintercept.ControlEvent;
import com.fantasticsource.mctools.sound.SimpleSound;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Network {
    public static final SimpleNetworkWrapper WRAPPER = new SimpleNetworkWrapper("fantasticlib");
    private static int discriminator = 0;

    public static void init() {
        WRAPPER.registerMessage(PlaySimpleSoundPacketHandler.class, PlaySimpleSoundPacket.class, discriminator++, Side.CLIENT);
        WRAPPER.registerMessage(ControlEventPacketHandler.class, ControlEventPacket.class, discriminator++, Side.SERVER);
    }

    public static class ControlEventPacketHandler
    implements IMessageHandler<ControlEventPacket, IMessage> {
        public IMessage onMessage(ControlEventPacket packet, MessageContext ctx) {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            server.func_152344_a(() -> MinecraftForge.EVENT_BUS.post((Event)packet.event.setPlayer(ctx.getServerHandler().field_147369_b)));
            return null;
        }
    }

    public static class ControlEventPacket
    implements IMessage {
        public ControlEvent event;

        public ControlEventPacket() {
        }

        public ControlEventPacket(ControlEvent event) {
            this.event = event;
        }

        public void toBytes(ByteBuf buf) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.event.name);
            buf.writeBoolean(this.event.state);
            buf.writeBoolean(this.event.lastState != null);
            if (this.event.lastState != null) {
                buf.writeBoolean(this.event.lastState.booleanValue());
            }
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.event.identifier);
        }

        public void fromBytes(ByteBuf buf) {
            this.event = new ControlEvent(ByteBufUtils.readUTF8String((ByteBuf)buf), buf.readBoolean(), buf.readBoolean() ? Boolean.valueOf(buf.readBoolean()) : null, ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
    }

    public static class PlaySimpleSoundPacketHandler
    implements IMessageHandler<PlaySimpleSoundPacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(PlaySimpleSoundPacket packet, MessageContext ctx) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_152344_a(() -> mc.func_147118_V().func_147682_a((ISound)new SimpleSound(packet.rl.value, SoundCategory.MASTER)));
            return null;
        }
    }

    public static class PlaySimpleSoundPacket
    implements IMessage {
        public CResourceLocation rl = new CResourceLocation();

        public PlaySimpleSoundPacket() {
        }

        public PlaySimpleSoundPacket(ResourceLocation rl) {
            this.rl.set(rl);
        }

        public void toBytes(ByteBuf buf) {
            this.rl.write(buf);
        }

        public void fromBytes(ByteBuf buf) {
            this.rl.read(buf);
        }
    }
}

