/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools;

import com.fantasticsource.tools.datastructures.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public class MonoASCIIFontRenderer {
    public static final int LINE_HEIGHT;
    public static final int CHAR_WIDTH;
    public static final int CHAR_HEIGHT;
    private static final TextureManager TEXTURE_MANAGER;
    private static final double CHAR_UV = 0.0625;
    private static final double CHAR_U_TO_RIGHT;
    private static final double CHAR_V_TO_BOTTOM;
    private static final ResourceLocation TEXTURE;

    public static void draw(String text, double x, double y, Color color, Color shadowColor) {
        if (shadowColor.a() <= 0 && color.a() <= 0) {
            return;
        }
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179098_w();
        TEXTURE_MANAGER.func_110577_a(TEXTURE);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181711_k);
        if (shadowColor.a() > 0) {
            MonoASCIIFontRenderer.drawText(text, bufferBuilder, x, y + 1.0, shadowColor);
            MonoASCIIFontRenderer.drawText(text, bufferBuilder, x + 2.0, y + 1.0, shadowColor);
            MonoASCIIFontRenderer.drawText(text, bufferBuilder, x + 1.0, y, shadowColor);
            MonoASCIIFontRenderer.drawText(text, bufferBuilder, x + 1.0, y + 2.0, shadowColor);
        }
        if (color.a() > 0) {
            MonoASCIIFontRenderer.drawText(text, bufferBuilder, x + 1.0, y + 1.0, color);
        }
        tessellator.func_78381_a();
    }

    public static int getStringWidth(String text) {
        return text.length() * (CHAR_WIDTH + 2);
    }

    private static void drawText(String text, BufferBuilder bufferBuilder, double left, double top, Color color) {
        for (char c : text.toCharArray()) {
            if (c < '\u0100') {
                MonoASCIIFontRenderer.drawChar(c, bufferBuilder, left, top, color.r(), color.g(), color.b(), color.a());
            }
            left += (double)(CHAR_WIDTH + 2);
        }
    }

    private static void drawChar(char c, BufferBuilder bufferBuilder, double left, double top, int r, int g, int b, int a) {
        double u = (double)(c % 16) * 0.0625;
        double v = (double)(c >> 4) * 0.0625;
        bufferBuilder.func_181662_b(left, top, 0.0).func_187315_a(u, v).func_187314_a(0xF000F0, 0xF000F0).func_181669_b(r, g, b, a).func_181675_d();
        bufferBuilder.func_181662_b(left, top + (double)CHAR_HEIGHT, 0.0).func_187315_a(u, v + CHAR_V_TO_BOTTOM).func_187314_a(0xF000F0, 0xF000F0).func_181669_b(r, g, b, a).func_181675_d();
        bufferBuilder.func_181662_b(left + (double)CHAR_WIDTH, top + (double)CHAR_HEIGHT, 0.0).func_187315_a(u + CHAR_U_TO_RIGHT, v + CHAR_V_TO_BOTTOM).func_187314_a(0xF000F0, 0xF000F0).func_181669_b(r, g, b, a).func_181675_d();
        bufferBuilder.func_181662_b(left + (double)CHAR_WIDTH, top, 0.0).func_187315_a(u + CHAR_U_TO_RIGHT, v).func_187314_a(0xF000F0, 0xF000F0).func_181669_b(r, g, b, a).func_181675_d();
    }

    static {
        TEXTURE_MANAGER = Minecraft.func_71410_x().func_110434_K();
        TEXTURE = new ResourceLocation("fantasticlib", "image/monospace.png");
        CHAR_WIDTH = 8;
        CHAR_HEIGHT = 8;
        LINE_HEIGHT = CHAR_HEIGHT + 2;
        CHAR_U_TO_RIGHT = 0.0625 - 0.0625 / (double)(CHAR_WIDTH << 1);
        CHAR_V_TO_BOTTOM = 0.0625 - 0.0625 / (double)(CHAR_HEIGHT << 1);
    }
}

