/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import com.fantasticsource.fantasticlib.Compat;
import com.fantasticsource.tiamatrpg.api.ITiamatPlayerInventory;
import com.fantasticsource.tiamatrpg.api.TiamatRPGAPI;
import com.fantasticsource.tools.ReflectionTool;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.UUID;
import moe.plushie.armourers_workshop.api.ArmourersWorkshopApi;
import moe.plushie.armourers_workshop.api.common.capability.IEntitySkinCapability;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinType;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinTypeRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class GlobalInventory {
    public static ISkinTypeRegistry skinTypeRegistry = ArmourersWorkshopApi.skinTypeRegistry;
    protected static LinkedHashMap<UUID, IInventory> tiamatServerInventories = null;

    public static ArrayList<ItemStack> getAllItems(Entity entity) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        ItemStack stack = GlobalInventory.getVanillaMainhandItem(entity);
        if (stack != null) {
            result.add(stack);
        }
        result.addAll(GlobalInventory.getVanillaOffhandItems(entity));
        result.addAll(GlobalInventory.getVanillaArmorItems(entity));
        result.addAll(GlobalInventory.getVanillaOtherInventoryItems(entity));
        result.addAll(GlobalInventory.getBaubles(entity));
        ITiamatPlayerInventory inventory = GlobalInventory.getTiamatInventory(entity);
        if (inventory != null) {
            result.addAll(inventory.getAllItems());
        }
        result.addAll(GlobalInventory.getAWSkins(entity));
        return result;
    }

    public static ArrayList<ItemStack> getAllEquippedItems(Entity entity) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        ItemStack stack = GlobalInventory.getVanillaMainhandItem(entity);
        if (stack != null) {
            result.add(stack);
        }
        result.addAll(GlobalInventory.getVanillaOffhandItems(entity));
        result.addAll(GlobalInventory.getVanillaArmorItems(entity));
        result.addAll(GlobalInventory.getBaubles(entity));
        ITiamatPlayerInventory inventory = GlobalInventory.getTiamatInventory(entity);
        if (inventory != null) {
            result.addAll(inventory.getAllEquippedItems());
        }
        result.addAll(GlobalInventory.getAWSkins(entity));
        return result;
    }

    public static ArrayList<ItemStack> getAllNonAWItems(Entity entity) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        ItemStack stack = GlobalInventory.getVanillaMainhandItem(entity);
        if (stack != null) {
            result.add(stack);
        }
        result.addAll(GlobalInventory.getVanillaOffhandItems(entity));
        result.addAll(GlobalInventory.getVanillaArmorItems(entity));
        result.addAll(GlobalInventory.getBaubles(entity));
        ITiamatPlayerInventory inventory = GlobalInventory.getTiamatInventory(entity);
        if (inventory != null) {
            result.addAll(inventory.getAllEquippedItems());
        }
        return result;
    }

    public static LinkedHashMap<String, ArrayList<ItemStack>> getAllItemsCategorized(Entity entity) {
        ITiamatPlayerInventory inventory;
        LinkedHashMap<String, ArrayList<ItemStack>> result = new LinkedHashMap<String, ArrayList<ItemStack>>();
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        ItemStack stack = GlobalInventory.getVanillaMainhandItem(entity);
        if (stack != null) {
            list.add(stack);
            result.put("Vanilla Mainhand", list);
            list = new ArrayList();
        }
        list.addAll(GlobalInventory.getVanillaOffhandItems(entity));
        if (list.size() > 0) {
            result.put("Vanilla Offhands", list);
            list = new ArrayList();
        }
        list.addAll(GlobalInventory.getVanillaArmorItems(entity));
        if (list.size() > 0) {
            result.put("Vanilla Armor", list);
            list = new ArrayList();
        }
        list.addAll(GlobalInventory.getVanillaOtherInventoryItems(entity));
        if (list.size() > 0) {
            result.put("Vanilla Other Inventory", list);
            list = new ArrayList();
        }
        list.addAll(GlobalInventory.getBaubles(entity));
        if (list.size() > 0) {
            result.put("Baubles Inventory", list);
            list = new ArrayList();
        }
        if ((inventory = GlobalInventory.getTiamatInventory(entity)) != null) {
            stack = GlobalInventory.getTiamatInactiveMainhand(inventory);
            if (stack != null) {
                list.add(stack);
                result.put("Tiamat Inactive Weaponset Mainhand", list);
                list = new ArrayList();
            }
            if ((stack = GlobalInventory.getTiamatInactiveOffhand(inventory)) != null) {
                list.add(stack);
                result.put("Tiamat Inactive Weaponset Offhand", list);
                list = new ArrayList();
            }
            list.addAll(GlobalInventory.getTiamatArmor(inventory));
            if (list.size() > 0) {
                result.put("Tiamat Armor", list);
                list = new ArrayList();
            }
            if ((stack = GlobalInventory.getTiamatPet(inventory)) != null) {
                list.add(stack);
                result.put("Tiamat Pet", list);
                list = new ArrayList();
            }
            list.addAll(GlobalInventory.getTiamatClasses(inventory));
            if (list.size() > 0) {
                result.put("Tiamat Classes", list);
                list = new ArrayList();
            }
            list.addAll(GlobalInventory.getTiamatSkills(inventory));
            if (list.size() > 0) {
                result.put("Tiamat Skills", list);
                list = new ArrayList();
            }
            list.addAll(GlobalInventory.getTiamatGatheringProfessions(inventory));
            if (list.size() > 0) {
                result.put("Tiamat Gathering Professions", list);
                list = new ArrayList();
            }
            list.addAll(GlobalInventory.getTiamatCraftingProfessions(inventory));
            if (list.size() > 0) {
                result.put("Tiamat Crafting Professions", list);
                list = new ArrayList();
            }
            list.addAll(GlobalInventory.getTiamatRecipes(inventory));
            if (list.size() > 0) {
                result.put("Tiamat Recipes", list);
                list = new ArrayList();
            }
            list.addAll(GlobalInventory.getTiamatReadySkills(inventory));
            if (list.size() > 0) {
                result.put("Tiamat Ready Skills", list);
                list = new ArrayList();
            }
        }
        list.addAll(GlobalInventory.getAWSkins(entity));
        if (list.size() > 0) {
            result.put("Armourer's Workshop Skins", list);
            list = new ArrayList();
        }
        return result;
    }

    public static ItemStack getVanillaMainhandItem(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            return ((EntityLivingBase)entity).func_184614_ca();
        }
        Iterator iterator = entity.func_184214_aD().iterator();
        if (iterator.hasNext()) {
            ItemStack stack = (ItemStack)iterator.next();
            return stack;
        }
        return null;
    }

    public static ArrayList<ItemStack> getVanillaOffhandItems(Entity entity) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        ItemStack mainhand = GlobalInventory.getVanillaMainhandItem(entity);
        for (ItemStack stack : entity.func_184214_aD()) {
            if (stack == mainhand || result.contains(stack)) continue;
            result.add(stack);
        }
        return result;
    }

    public static ArrayList<ItemStack> getVanillaArmorItems(Entity entity) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (ItemStack stack : entity.func_184193_aE()) {
            if (result.contains(stack)) continue;
            result.add(stack);
        }
        return result;
    }

    public static ArrayList<ItemStack> getVanillaOtherInventoryItems(Entity entity) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        if (!(entity instanceof EntityPlayer)) {
            return result;
        }
        ArrayList<ItemStack> ignore = new ArrayList<ItemStack>();
        ItemStack stack = GlobalInventory.getVanillaMainhandItem(entity);
        if (stack != null) {
            ignore.add(stack);
        }
        ignore.addAll(GlobalInventory.getVanillaOffhandItems(entity));
        ignore.addAll(GlobalInventory.getVanillaArmorItems(entity));
        InventoryPlayer inventory = ((EntityPlayer)entity).field_71071_by;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            stack = inventory.func_70301_a(i);
            if (result.contains(stack) || ignore.contains(stack)) continue;
            result.add(stack);
        }
        return result;
    }

    public static ArrayList<ItemStack> getBaubles(Entity entity) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        if (!Compat.baubles || !(entity instanceof EntityPlayer)) {
            return result;
        }
        IBaublesItemHandler inventory = BaublesApi.getBaublesHandler((EntityPlayer)entity);
        for (int i = 0; i < inventory.getSlots(); ++i) {
            result.add(inventory.getStackInSlot(i));
        }
        return result;
    }

    public static ITiamatPlayerInventory getTiamatInventory(Entity entity) {
        if (tiamatServerInventories == null || !(entity instanceof EntityPlayer)) {
            return null;
        }
        return TiamatRPGAPI.getTiamatPlayerInventory((EntityPlayer)entity);
    }

    public static ItemStack getTiamatInactiveMainhand(Entity entity) {
        return GlobalInventory.getTiamatInactiveMainhand(GlobalInventory.getTiamatInventory(entity));
    }

    public static ItemStack getTiamatInactiveMainhand(ITiamatPlayerInventory inventory) {
        return inventory == null ? null : inventory.getInactiveWeaponsetMainhand();
    }

    public static ItemStack getTiamatInactiveOffhand(Entity entity) {
        return GlobalInventory.getTiamatInactiveOffhand(GlobalInventory.getTiamatInventory(entity));
    }

    public static ItemStack getTiamatInactiveOffhand(ITiamatPlayerInventory inventory) {
        return inventory == null ? null : inventory.getInactiveWeaponsetOffhand();
    }

    public static ArrayList<ItemStack> getTiamatArmor(Entity entity) {
        return GlobalInventory.getTiamatArmor(GlobalInventory.getTiamatInventory(entity));
    }

    public static ArrayList<ItemStack> getTiamatArmor(ITiamatPlayerInventory inventory) {
        return inventory == null ? new ArrayList<ItemStack>() : new ArrayList<ItemStack>(inventory.getTiamatArmor());
    }

    public static ItemStack getTiamatPet(Entity entity) {
        return GlobalInventory.getTiamatPet(GlobalInventory.getTiamatInventory(entity));
    }

    public static ItemStack getTiamatPet(ITiamatPlayerInventory inventory) {
        return inventory == null ? null : inventory.getPet();
    }

    public static ArrayList<ItemStack> getTiamatClasses(Entity entity) {
        return GlobalInventory.getTiamatClasses(GlobalInventory.getTiamatInventory(entity));
    }

    public static ArrayList<ItemStack> getTiamatClasses(ITiamatPlayerInventory inventory) {
        return inventory == null ? new ArrayList<ItemStack>() : new ArrayList<ItemStack>(inventory.getPlayerClasses());
    }

    public static ArrayList<ItemStack> getTiamatSkills(Entity entity) {
        return GlobalInventory.getTiamatSkills(GlobalInventory.getTiamatInventory(entity));
    }

    public static ArrayList<ItemStack> getTiamatSkills(ITiamatPlayerInventory inventory) {
        return inventory == null ? new ArrayList<ItemStack>() : new ArrayList<ItemStack>(inventory.getSkills());
    }

    public static ArrayList<ItemStack> getTiamatGatheringProfessions(Entity entity) {
        return GlobalInventory.getTiamatGatheringProfessions(GlobalInventory.getTiamatInventory(entity));
    }

    public static ArrayList<ItemStack> getTiamatGatheringProfessions(ITiamatPlayerInventory inventory) {
        return inventory == null ? new ArrayList<ItemStack>() : new ArrayList<ItemStack>(inventory.getGatheringProfessions());
    }

    public static ArrayList<ItemStack> getTiamatCraftingProfessions(Entity entity) {
        return GlobalInventory.getTiamatCraftingProfessions(GlobalInventory.getTiamatInventory(entity));
    }

    public static ArrayList<ItemStack> getTiamatCraftingProfessions(ITiamatPlayerInventory inventory) {
        return inventory == null ? new ArrayList<ItemStack>() : new ArrayList<ItemStack>(inventory.getCraftingProfessions());
    }

    public static ArrayList<ItemStack> getTiamatRecipes(Entity entity) {
        return GlobalInventory.getTiamatRecipes(GlobalInventory.getTiamatInventory(entity));
    }

    public static ArrayList<ItemStack> getTiamatRecipes(ITiamatPlayerInventory inventory) {
        return inventory == null ? new ArrayList<ItemStack>() : new ArrayList<ItemStack>(inventory.getCraftingRecipes());
    }

    public static ArrayList<ItemStack> getTiamatReadySkills(Entity entity) {
        return GlobalInventory.getTiamatReadySkills(GlobalInventory.getTiamatInventory(entity));
    }

    public static ArrayList<ItemStack> getTiamatReadySkills(ITiamatPlayerInventory inventory) {
        return inventory == null ? new ArrayList<ItemStack>() : new ArrayList<ItemStack>(inventory.getReadySkills());
    }

    public static ArrayList<ItemStack> getAllTiamatItems(Entity entity) {
        return GlobalInventory.getAllTiamatItems(GlobalInventory.getTiamatInventory(entity));
    }

    public static ArrayList<ItemStack> getAllTiamatItems(ITiamatPlayerInventory inventory) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        if (inventory == null) {
            return result;
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            result.add(inventory.func_70301_a(i));
        }
        return result;
    }

    public static ISkinType getSkinType(String skinTypeName) {
        if (skinTypeRegistry == null) {
            return null;
        }
        return skinTypeRegistry.getSkinTypeFromRegistryName(skinTypeName);
    }

    public static int getAWSkinSlotCount(Entity entity, String skinTypeName) {
        return GlobalInventory.getAWSkinSlotCount(entity, GlobalInventory.getSkinType(skinTypeName));
    }

    public static int getAWSkinSlotCount(Entity entity, ISkinType skinType) {
        IEntitySkinCapability wardrobeSkinHandler = ArmourersWorkshopApi.getEntitySkinCapability(entity);
        if (wardrobeSkinHandler == null) {
            return 0;
        }
        return wardrobeSkinHandler.getSlotCountForSkinType(skinType);
    }

    public static ItemStack getAWSkin(Entity entity, String skinTypeName, int index) {
        return GlobalInventory.getAWSkin(entity, GlobalInventory.getSkinType(skinTypeName), index);
    }

    public static ItemStack getAWSkin(Entity entity, ISkinType skinType, int index) {
        IEntitySkinCapability wardrobeSkinHandler = ArmourersWorkshopApi.getEntitySkinCapability(entity);
        if (wardrobeSkinHandler == null) {
            return null;
        }
        return wardrobeSkinHandler.getSkinStack(skinType, index);
    }

    public static ArrayList<ItemStack> getAWSkinsOfType(Entity entity, String skinTypeName) {
        return GlobalInventory.getAWSkinsOfType(entity, GlobalInventory.getSkinType(skinTypeName));
    }

    public static ArrayList<ItemStack> getAWSkinsOfType(Entity entity, ISkinType skinType) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        int size = GlobalInventory.getAWSkinSlotCount(entity, skinType);
        for (int i = 0; i < size; ++i) {
            result.add(GlobalInventory.getAWSkin(entity, skinType, i));
        }
        return result;
    }

    public static ArrayList<ItemStack> getAWSkins(Entity entity) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        IEntitySkinCapability wardrobeSkinHandler = ArmourersWorkshopApi.getEntitySkinCapability(entity);
        if (wardrobeSkinHandler == null) {
            return result;
        }
        for (ISkinType skinTypeObject : wardrobeSkinHandler.getValidSkinTypes()) {
            result.addAll(GlobalInventory.getAWSkinsOfType(entity, skinTypeObject));
        }
        return result;
    }

    public static ItemStack setAWSkin(Entity entity, String skinTypeName, int index, ItemStack newSkin) {
        return GlobalInventory.setAWSkin(entity, GlobalInventory.getSkinType(skinTypeName), index, newSkin);
    }

    public static ItemStack setAWSkin(Entity entity, ISkinType skinType, int index, ItemStack newSkin) {
        IEntitySkinCapability wardrobeSkinHandler = ArmourersWorkshopApi.getEntitySkinCapability(entity);
        if (wardrobeSkinHandler == null) {
            return null;
        }
        return wardrobeSkinHandler.setSkinStack(skinType, index, newSkin);
    }

    public static ISkinType[] getValidSkinTypes(Entity entity) {
        IEntitySkinCapability wardrobeSkinHandler = ArmourersWorkshopApi.getEntitySkinCapability(entity);
        if (wardrobeSkinHandler == null) {
            return null;
        }
        return wardrobeSkinHandler.getValidSkinTypes();
    }

    public static ArrayList<String> getValidSkinTypeNames(Entity entity) {
        ArrayList<String> result = new ArrayList<String>();
        for (ISkinType skinTypeObject : GlobalInventory.getValidSkinTypes(entity)) {
            result.add(skinTypeObject.getName());
        }
        return result;
    }

    public static void syncAWWardrobeSkins(Entity entity, boolean syncToSelf, boolean syncToOthers) {
        IEntitySkinCapability wardrobeSkinHandler = ArmourersWorkshopApi.getEntitySkinCapability(entity);
        if (wardrobeSkinHandler == null) {
            return;
        }
        if (syncToSelf && entity instanceof EntityPlayerMP) {
            wardrobeSkinHandler.syncToPlayer((EntityPlayerMP)entity);
        }
        if (syncToOthers) {
            wardrobeSkinHandler.syncToAllTracking();
        }
    }

    static {
        if (Compat.tiamatrpg) {
            Class tiamatPlayerInventoryClass = ReflectionTool.getClassByName("com.fantasticsource.tiamatrpg.inventory.TiamatPlayerInventory");
            Field tiamatServerInventoriesField = ReflectionTool.getField(tiamatPlayerInventoryClass, "tiamatServerInventories");
            tiamatServerInventories = (LinkedHashMap)ReflectionTool.get(tiamatServerInventoriesField, null);
        }
    }
}

