/*
 * Decompiled with CFR 0.152.
 */
package com.clownvin.livingenchantment.command;

import com.clownvin.livingenchantment.LivingEnchantment;
import com.clownvin.livingenchantment.config.LivingConfig;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;

public class CommandSetItemLevel
extends CommandBase {
    public int func_82362_a() {
        return 2;
    }

    public String func_71517_b() {
        return "setitemlevel";
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.setitemlevel.usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        EntityPlayerMP player = CommandSetItemLevel.func_71521_c((ICommandSender)sender);
        if (args.length < 1) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        try {
            int level = Integer.parseInt(args[0]);
            if (level < 0 || level > LivingConfig.general.maxLevel) {
                throw new WrongUsageException("commands.setitemlevel.invalid_level_number", new Object[]{LivingConfig.general.maxLevel});
            }
            ItemStack held = player.func_184614_ca();
            NBTTagCompound tag = LivingEnchantment.getEnchantmentNBTTag(held);
            if (tag == null) {
                throw new WrongUsageException("commands.livingenchantment.mainhand_item_not_living", new Object[0]);
            }
            LivingEnchantment.setExp((EntityPlayer)player, held, tag, LivingEnchantment.lvlToXp(level) + 0.5);
            CommandSetItemLevel.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.setitemlevel.success", (Object[])new Object[]{held.func_82833_r(), level});
        }
        catch (NumberFormatException e) {
            throw new WrongUsageException("commands.setitemlevel.invalid_level_number", new Object[0]);
        }
    }
}

