/*
 * Decompiled with CFR 0.152.
 */
package exterminatorjeff.undergroundbiomes.intermod;

import exterminatorjeff.undergroundbiomes.api.API;
import exterminatorjeff.undergroundbiomes.api.common.UBStonesRegistry;
import exterminatorjeff.undergroundbiomes.api.enums.UBStoneStyle;
import exterminatorjeff.undergroundbiomes.api.enums.UBStoneType;
import exterminatorjeff.undergroundbiomes.api.names.ButtonEntry;
import exterminatorjeff.undergroundbiomes.api.names.Entry;
import exterminatorjeff.undergroundbiomes.api.names.SlabEntry;
import exterminatorjeff.undergroundbiomes.api.names.StairsEntry;
import exterminatorjeff.undergroundbiomes.api.names.StoneEntry;
import exterminatorjeff.undergroundbiomes.api.names.WallEntry;
import java.util.ArrayList;
import java.util.List;

public enum StonesRegistry implements UBStonesRegistry
{
    INSTANCE;


    private StoneEntry getStoneEntry(UBStoneType type, UBStoneStyle style) {
        switch (type) {
            case IGNEOUS: {
                switch (style) {
                    case STONE: {
                        return API.IGNEOUS_STONE;
                    }
                    case COBBLE: {
                        return API.IGNEOUS_COBBLE;
                    }
                    case BRICK: {
                        return API.IGNEOUS_BRICK;
                    }
                    case OVERGROWN: {
                        return API.IGNEOUS_OVERGROWN;
                    }
                    case OVERGROWN_SNOWED: {
                        return API.IGNEOUS_OVERGROWN_SNOWED;
                    }
                    case MOSSY_COBBLE: {
                        return API.IGNEOUS_MOSSY_COBBLE;
                    }
                    case MONSTER_STONE: {
                        return API.IGNEOUS_MONSTER_STONE;
                    }
                    case SPELEOTHEM: {
                        return API.IGNEOUS_SPELEOTHEM;
                    }
                    case GRAVEL: {
                        return API.IGNEOUS_GRAVEL;
                    }
                    case SAND: {
                        return API.IGNEOUS_SAND;
                    }
                    case CLAY: {
                        return API.IGNEOUS_CLAY;
                    }
                    case SANDSTONE: {
                        return API.IGNEOUS_SANDSTONE;
                    }
                    case SMOOTH_SANDSTONE: {
                        return API.IGNEOUS_SMOOTH_SANDSTONE;
                    }
                    case CHISELED_SANDSTONE: {
                        return API.IGNEOUS_CHISELED_SANDSTONE;
                    }
                }
                break;
            }
            case METAMORPHIC: {
                switch (style) {
                    case STONE: {
                        return API.METAMORPHIC_STONE;
                    }
                    case COBBLE: {
                        return API.METAMORPHIC_COBBLE;
                    }
                    case BRICK: {
                        return API.METAMORPHIC_BRICK;
                    }
                    case OVERGROWN: {
                        return API.METAMORPHIC_OVERGROWN;
                    }
                    case OVERGROWN_SNOWED: {
                        return API.METAMORPHIC_OVERGROWN_SNOWED;
                    }
                    case MOSSY_COBBLE: {
                        return API.METAMORPHIC_MOSSY_COBBLE;
                    }
                    case MONSTER_STONE: {
                        return API.METAMORPHIC_MONSTER_STONE;
                    }
                    case SPELEOTHEM: {
                        return API.METAMORPHIC_SPELEOTHEM;
                    }
                    case GRAVEL: {
                        return API.METAMORPHIC_GRAVEL;
                    }
                    case SAND: {
                        return API.METAMORPHIC_SAND;
                    }
                    case CLAY: {
                        return API.METAMORPHIC_CLAY;
                    }
                    case SANDSTONE: {
                        return API.METAMORPHIC_SANDSTONE;
                    }
                    case SMOOTH_SANDSTONE: {
                        return API.METAMORPHIC_SMOOTH_SANDSTONE;
                    }
                    case CHISELED_SANDSTONE: {
                        return API.METAMORPHIC_CHISELED_SANDSTONE;
                    }
                }
                break;
            }
            case SEDIMENTARY: {
                switch (style) {
                    case STONE: {
                        return API.SEDIMENTARY_STONE;
                    }
                    case COBBLE: {
                        return API.SEDIMENTARY_STONE;
                    }
                    case BRICK: {
                        return API.SEDIMENTARY_STONE;
                    }
                    case OVERGROWN: {
                        return API.SEDIMENTARY_OVERGROWN;
                    }
                    case OVERGROWN_SNOWED: {
                        return API.SEDIMENTARY_OVERGROWN_SNOWED;
                    }
                    case MOSSY_COBBLE: {
                        return API.SEDIMENTARY_MOSSY_COBBLE;
                    }
                    case MONSTER_STONE: {
                        return API.SEDIMENTARY_MONSTER_STONE;
                    }
                    case SPELEOTHEM: {
                        return API.SEDIMENTARY_SPELEOTHEM;
                    }
                    case GRAVEL: {
                        return API.SEDIMENTARY_GRAVEL;
                    }
                    case SAND: {
                        return API.SEDIMENTARY_SAND;
                    }
                    case CLAY: {
                        return API.SEDIMENTARY_CLAY;
                    }
                    case SANDSTONE: {
                        return API.SEDIMENTARY_SANDSTONE;
                    }
                    case SMOOTH_SANDSTONE: {
                        return API.SEDIMENTARY_SMOOTH_SANDSTONE;
                    }
                    case CHISELED_SANDSTONE: {
                        return API.SEDIMENTARY_CHISELED_SANDSTONE;
                    }
                }
            }
        }
        return null;
    }

    private <T extends Entry<?>> void addIfRegistered(List<T> list, T entry) {
        if (entry.isRegistered()) {
            list.add(entry);
        }
    }

    @Override
    public List<StoneEntry> allStones() {
        ArrayList<StoneEntry> stones = new ArrayList<StoneEntry>();
        this.addIfRegistered(stones, API.IGNEOUS_STONE);
        this.addIfRegistered(stones, API.IGNEOUS_COBBLE);
        this.addIfRegistered(stones, API.IGNEOUS_BRICK);
        this.addIfRegistered(stones, API.IGNEOUS_OVERGROWN);
        this.addIfRegistered(stones, API.METAMORPHIC_STONE);
        this.addIfRegistered(stones, API.METAMORPHIC_COBBLE);
        this.addIfRegistered(stones, API.METAMORPHIC_BRICK);
        this.addIfRegistered(stones, API.METAMORPHIC_OVERGROWN);
        this.addIfRegistered(stones, API.SEDIMENTARY_STONE);
        this.addIfRegistered(stones, API.SEDIMENTARY_OVERGROWN);
        return stones;
    }

    @Override
    public List<StoneEntry> stonesFor(UBStoneType type) {
        ArrayList<StoneEntry> stones = new ArrayList<StoneEntry>();
        for (UBStoneStyle style : UBStoneStyle.values()) {
            this.addIfRegistered(stones, this.getStoneEntry(type, style));
        }
        return stones;
    }

    @Override
    public List<StoneEntry> stonesFor(UBStoneType type1, UBStoneType type2) {
        List<StoneEntry> stones = this.stonesFor(type1);
        stones.addAll(this.stonesFor(type2));
        return stones;
    }

    @Override
    public List<StoneEntry> stonesFor(UBStoneStyle style) {
        ArrayList<StoneEntry> stones = new ArrayList<StoneEntry>();
        for (UBStoneType type : UBStoneType.values()) {
            this.addIfRegistered(stones, this.getStoneEntry(type, style));
        }
        return stones;
    }

    @Override
    public List<StoneEntry> stonesFor(UBStoneStyle style1, UBStoneStyle style2) {
        List<StoneEntry> stones = this.stonesFor(style1);
        stones.addAll(this.stonesFor(style2));
        return stones;
    }

    @Override
    public StoneEntry stoneFor(UBStoneType type, UBStoneStyle style) {
        return this.getStoneEntry(type, style);
    }

    @Override
    public List<SlabEntry> allSlabs() {
        ArrayList<SlabEntry> slabs = new ArrayList<SlabEntry>();
        this.addIfRegistered(slabs, API.IGNEOUS_STONE_SLAB);
        this.addIfRegistered(slabs, API.IGNEOUS_COBBLE_SLAB);
        this.addIfRegistered(slabs, API.IGNEOUS_BRICK_SLAB);
        this.addIfRegistered(slabs, API.METAMORPHIC_STONE_SLAB);
        this.addIfRegistered(slabs, API.METAMORPHIC_COBBLE_SLAB);
        this.addIfRegistered(slabs, API.METAMORPHIC_BRICK_SLAB);
        this.addIfRegistered(slabs, API.SEDIMENTARY_STONE_SLAB);
        return slabs;
    }

    @Override
    public List<SlabEntry> slabsFor(UBStoneType type) {
        ArrayList<SlabEntry> slabs = new ArrayList<SlabEntry>();
        for (UBStoneStyle style : UBStoneStyle.values()) {
            this.addIfRegistered(slabs, this.getStoneEntry(type, style).getSlab());
        }
        return slabs;
    }

    @Override
    public List<SlabEntry> slabsFor(UBStoneType type1, UBStoneType type2) {
        List<SlabEntry> slabs = this.slabsFor(type1);
        slabs.addAll(this.slabsFor(type2));
        return slabs;
    }

    @Override
    public List<SlabEntry> slabsFor(UBStoneStyle style) {
        ArrayList<SlabEntry> slabs = new ArrayList<SlabEntry>();
        for (UBStoneType type : UBStoneType.values()) {
            this.addIfRegistered(slabs, this.getStoneEntry(type, style).getSlab());
        }
        return slabs;
    }

    @Override
    public List<SlabEntry> slabsFor(UBStoneStyle style1, UBStoneStyle style2) {
        List<SlabEntry> slabs = this.slabsFor(style1);
        slabs.addAll(this.slabsFor(style2));
        return slabs;
    }

    @Override
    public SlabEntry slabFor(UBStoneType type, UBStoneStyle style) {
        return this.getStoneEntry(type, style).getSlab();
    }

    @Override
    public List<ButtonEntry> allButtons() {
        ArrayList<ButtonEntry> buttons = new ArrayList<ButtonEntry>();
        this.addIfRegistered(buttons, API.IGNEOUS_STONE_BUTTON);
        this.addIfRegistered(buttons, API.IGNEOUS_COBBLE_BUTTON);
        this.addIfRegistered(buttons, API.IGNEOUS_BRICK_BUTTON);
        this.addIfRegistered(buttons, API.METAMORPHIC_STONE_BUTTON);
        this.addIfRegistered(buttons, API.METAMORPHIC_COBBLE_BUTTON);
        this.addIfRegistered(buttons, API.METAMORPHIC_BRICK_BUTTON);
        this.addIfRegistered(buttons, API.SEDIMENTARY_STONE_BUTTON);
        return buttons;
    }

    @Override
    public List<ButtonEntry> buttonsFor(UBStoneType type) {
        ArrayList<ButtonEntry> buttons = new ArrayList<ButtonEntry>();
        for (UBStoneStyle style : UBStoneStyle.values()) {
            this.addIfRegistered(buttons, this.getStoneEntry(type, style).getButton());
        }
        return buttons;
    }

    @Override
    public List<ButtonEntry> buttonsFor(UBStoneType type1, UBStoneType type2) {
        List<ButtonEntry> buttons = this.buttonsFor(type1);
        buttons.addAll(this.buttonsFor(type2));
        return buttons;
    }

    @Override
    public List<ButtonEntry> buttonsFor(UBStoneStyle style) {
        ArrayList<ButtonEntry> buttons = new ArrayList<ButtonEntry>();
        for (UBStoneType type : UBStoneType.values()) {
            this.addIfRegistered(buttons, this.getStoneEntry(type, style).getButton());
        }
        return buttons;
    }

    @Override
    public List<ButtonEntry> buttonsFor(UBStoneStyle style1, UBStoneStyle style2) {
        List<ButtonEntry> buttons = this.buttonsFor(style1);
        buttons.addAll(this.buttonsFor(style2));
        return buttons;
    }

    @Override
    public ButtonEntry buttonFor(UBStoneType type, UBStoneStyle style) {
        return this.getStoneEntry(type, style).getButton();
    }

    @Override
    public List<StairsEntry> allStairs() {
        ArrayList<StairsEntry> stairs = new ArrayList<StairsEntry>();
        this.addIfRegistered(stairs, API.IGNEOUS_STONE_STAIRS);
        this.addIfRegistered(stairs, API.IGNEOUS_COBBLE_STAIRS);
        this.addIfRegistered(stairs, API.IGNEOUS_BRICK_STAIRS);
        this.addIfRegistered(stairs, API.METAMORPHIC_STONE_STAIRS);
        this.addIfRegistered(stairs, API.METAMORPHIC_COBBLE_STAIRS);
        this.addIfRegistered(stairs, API.METAMORPHIC_BRICK_STAIRS);
        this.addIfRegistered(stairs, API.SEDIMENTARY_STONE_STAIRS);
        return stairs;
    }

    @Override
    public List<StairsEntry> stairsFor(UBStoneType type) {
        ArrayList<StairsEntry> stairs = new ArrayList<StairsEntry>();
        for (UBStoneStyle style : UBStoneStyle.values()) {
            this.addIfRegistered(stairs, this.getStoneEntry(type, style).getStairs());
        }
        return stairs;
    }

    @Override
    public List<StairsEntry> stairsFor(UBStoneType type1, UBStoneType type2) {
        List<StairsEntry> stairs = this.stairsFor(type1);
        stairs.addAll(this.stairsFor(type2));
        return stairs;
    }

    @Override
    public List<StairsEntry> stairsFor(UBStoneStyle style) {
        ArrayList<StairsEntry> stairs = new ArrayList<StairsEntry>();
        for (UBStoneType type : UBStoneType.values()) {
            this.addIfRegistered(stairs, this.getStoneEntry(type, style).getStairs());
        }
        return stairs;
    }

    @Override
    public List<StairsEntry> stairsFor(UBStoneStyle style1, UBStoneStyle style2) {
        List<StairsEntry> stairs = this.stairsFor(style1);
        stairs.addAll(this.stairsFor(style2));
        return stairs;
    }

    @Override
    public StairsEntry stairsFor(UBStoneType type, UBStoneStyle style) {
        return this.getStoneEntry(type, style).getStairs();
    }

    @Override
    public List<WallEntry> allWalls() {
        ArrayList<WallEntry> walls = new ArrayList<WallEntry>();
        this.addIfRegistered(walls, API.IGNEOUS_STONE_WALL);
        this.addIfRegistered(walls, API.IGNEOUS_COBBLE_WALL);
        this.addIfRegistered(walls, API.IGNEOUS_BRICK_WALL);
        this.addIfRegistered(walls, API.METAMORPHIC_STONE_WALL);
        this.addIfRegistered(walls, API.METAMORPHIC_COBBLE_WALL);
        this.addIfRegistered(walls, API.METAMORPHIC_BRICK_WALL);
        this.addIfRegistered(walls, API.SEDIMENTARY_STONE_WALL);
        return walls;
    }

    @Override
    public List<WallEntry> wallsFor(UBStoneType type) {
        ArrayList<WallEntry> walls = new ArrayList<WallEntry>();
        for (UBStoneStyle style : UBStoneStyle.values()) {
            this.addIfRegistered(walls, this.getStoneEntry(type, style).getWall());
        }
        return walls;
    }

    @Override
    public List<WallEntry> wallsFor(UBStoneType type1, UBStoneType type2) {
        List<WallEntry> walls = this.wallsFor(type1);
        walls.addAll(this.wallsFor(type2));
        return walls;
    }

    @Override
    public List<WallEntry> wallsFor(UBStoneStyle style) {
        ArrayList<WallEntry> walls = new ArrayList<WallEntry>();
        for (UBStoneType type : UBStoneType.values()) {
            this.addIfRegistered(walls, this.getStoneEntry(type, style).getWall());
        }
        return walls;
    }

    @Override
    public List<WallEntry> wallsFor(UBStoneStyle style1, UBStoneStyle style2) {
        List<WallEntry> walls = this.wallsFor(style1);
        walls.addAll(this.wallsFor(style2));
        return walls;
    }

    @Override
    public WallEntry wallFor(UBStoneType type, UBStoneStyle style) {
        return this.getStoneEntry(type, style).getWall();
    }
}

