/*
 * Decompiled with CFR 0.152.
 */
package exterminatorjeff.undergroundbiomes.config;

import exterminatorjeff.undergroundbiomes.config.SettingOverride;
import exterminatorjeff.undergroundbiomes.config.SettingTracker;
import exterminatorjeff.undergroundbiomes.config.UBConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

abstract class Setting<T> {
    protected final String category;
    protected final String key;
    protected final List<SettingTracker<T>> trackers = new ArrayList<SettingTracker<T>>();
    protected final List<SettingOverride<T, ?>> overrides = new ArrayList();
    protected Property property;

    public Setting(String category, String key) {
        this.category = category;
        this.key = key;
    }

    public void initProperty(Configuration configuration, T defaultValue, String comment) {
        UBConfig.LOGGER.trace("Creating property " + this.key + " with default value " + defaultValue);
        this.createProperty(configuration, defaultValue, comment);
        UBConfig.LOGGER.debug("Property " + this.key + " initialized with value " + this.getValue());
    }

    protected abstract void createProperty(Configuration var1, T var2, String var3);

    public final void changeValue(T value) {
        UBConfig.LOGGER.trace("Changing value of property " + this.key + ", previous value: " + this.getValue());
        this.setValue(value);
        UBConfig.LOGGER.info("Property " + this.key + ": value changed to " + value);
        this.overrides.forEach(setting -> setting.apply());
        this.trackers.forEach(tracker -> tracker.update(value));
    }

    protected abstract void setValue(T var1);

    public abstract T getValue();

    public final void addTracker(SettingTracker<T> tracker) {
        UBConfig.LOGGER.debug("Adding tracker to property " + this.key);
        this.trackers.add(tracker);
    }

    public final void addTrackerAndUpdate(SettingTracker<T> tracker) {
        UBConfig.LOGGER.debug("Adding tracker to property " + this.key);
        this.trackers.add(tracker);
        tracker.update(this.getValue());
    }

    public final <U> Setting<T> addOverride(T condition, Setting<U> setting, U forcedValue) {
        UBConfig.LOGGER.debug("Adding override to property " + this.key);
        UBConfig.LOGGER.debug("If value == " + condition + " -> " + setting.key + " = " + forcedValue);
        this.overrides.add(new SettingOverride<T, U>(this, condition, setting, forcedValue));
        if (this.valueEquals(condition)) {
            setting.setValue(forcedValue);
        }
        return this;
    }

    protected abstract boolean valueEquals(T var1);
}

