/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.extraalchemy.inventory;

import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandler;

public abstract class AutomatableInventory
implements IInventory,
IItemHandler {
    NonNullList<ItemStack> stacks;

    public AutomatableInventory(int slots) {
        this.stacks = NonNullList.func_191197_a((int)slots, (Object)ItemStack.field_190927_a);
    }

    public int getSlots() {
        return this.stacks.size();
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (this.canMachineInsert(slot, stack)) {
            return this.insertItemUnchecked(slot, stack, simulate);
        }
        return stack;
    }

    public ItemStack insertItemUnchecked(int slot, ItemStack stack, boolean simulate) {
        int inserted;
        ItemStack stackPresent = this.func_70301_a(slot);
        if (stackPresent.func_190926_b()) {
            if (!simulate) {
                this.func_70299_a(slot, stack.func_77946_l());
                this.func_70296_d();
            }
            return ItemStack.field_190927_a;
        }
        if (ItemStack.func_179545_c((ItemStack)stack, (ItemStack)stackPresent) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)stackPresent) && (inserted = Math.min(stack.func_190916_E(), stackPresent.func_77976_d() - stackPresent.func_190916_E())) > 0) {
            if (simulate) {
                return stack.func_77946_l().func_77979_a(stack.func_190916_E() - inserted);
            }
            stackPresent.func_190917_f(inserted);
            this.func_70296_d();
            return stack.func_77946_l().func_77979_a(stack.func_190916_E() - inserted);
        }
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.canMachineExtract(slot, this.func_70301_a(slot).func_77946_l().func_77979_a(amount))) {
            ItemStack tgt;
            if (simulate) {
                tgt = this.func_70301_a(slot).func_77946_l().func_77979_a(amount);
            } else {
                tgt = this.func_70301_a(slot).func_77979_a(amount);
                this.func_70296_d();
            }
            return tgt;
        }
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public int func_70302_i_() {
        return this.getSlots();
    }

    public boolean func_191420_l() {
        return !this.stacks.stream().anyMatch(is -> !is.func_190926_b());
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.stacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack res = this.func_70301_a(index).func_77979_a(count);
        this.func_70296_d();
        return res;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack res = this.func_70301_a(index);
        this.stacks.set(index, (Object)ItemStack.field_190927_a);
        this.func_70296_d();
        return res;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.stacks.set(index, (Object)stack);
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        this.onMarkDirty();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.canMachineInsert(index, stack);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.stacks.clear();
    }

    public void loadFromNBT(NBTTagCompound tag) {
        ItemStackHelper.func_191283_b((NBTTagCompound)tag, this.stacks);
    }

    public NBTTagCompound saveToNbt() {
        NBTTagCompound tag = new NBTTagCompound();
        ItemStackHelper.func_191281_a((NBTTagCompound)tag, this.stacks, (boolean)true);
        return tag;
    }

    public abstract boolean canMachineInsert(int var1, ItemStack var2);

    public abstract boolean canMachineExtract(int var1, ItemStack var2);

    public abstract void onMarkDirty();

    public void setStackInSlot(int i, ItemStack stack) {
        this.func_70299_a(i, stack);
    }

    public List<ItemStack> getList() {
        return Collections.unmodifiableList(this.stacks);
    }
}

