/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.jvoxelizer.util.stream.multimap;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class MultiMapCollector<T, K, V>
implements Collector<T, Multimap<K, V>, Multimap<K, V>> {
    private final Function<T, K> keyGetter;
    private final Function<T, V> valueGetter;

    public MultiMapCollector(Function<T, K> keyGetter, Function<T, V> valueGetter) {
        this.keyGetter = keyGetter;
        this.valueGetter = valueGetter;
    }

    public static <T, K, V> MultiMapCollector<T, K, V> toMultimap(Function<T, K> keyGetter, Function<T, V> valueGetter) {
        return new MultiMapCollector<T, K, V>(keyGetter, valueGetter);
    }

    public static <T, K, V> MultiMapCollector<T, K, T> toMultimap(Function<T, K> keyGetter) {
        return new MultiMapCollector<Object, K, Object>(keyGetter, v -> v);
    }

    @Override
    public Supplier<Multimap<K, V>> supplier() {
        return ArrayListMultimap::create;
    }

    @Override
    public BiConsumer<Multimap<K, V>, T> accumulator() {
        return (map, element) -> map.put(this.keyGetter.apply(element), this.valueGetter.apply(element));
    }

    @Override
    public BinaryOperator<Multimap<K, V>> combiner() {
        return (map1, map2) -> {
            map1.putAll(map2);
            return map1;
        };
    }

    @Override
    public Function<Multimap<K, V>, Multimap<K, V>> finisher() {
        return map -> map;
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return ImmutableSet.of((Object)((Object)Collector.Characteristics.IDENTITY_FINISH));
    }
}

