/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.jvoxelizer.util.distribution.executor;

import com.ldtteam.jvoxelizer.util.distribution.executor.IDistributionExectorHolder;
import java.util.function.Supplier;

public interface IDistributionExecutor {
    public static void on(Runnable clientSide, Runnable serverSide) {
        IDistributionExecutor.onClient(clientSide);
        IDistributionExecutor.onServer(serverSide);
    }

    public static void onClient(Runnable runnable) {
        IDistributionExectorHolder.getInstance().runOnClient(runnable);
    }

    public static void onServer(Runnable runnable) {
        IDistributionExectorHolder.getInstance().runOnServer(runnable);
    }

    public static <T> T on(Supplier<T> clientSide, Supplier<T> serverSide) {
        return IDistributionExectorHolder.getInstance().runOn(clientSide, serverSide);
    }

    public void runOnClient(Runnable var1);

    public void runOnServer(Runnable var1);

    public <T> T runOn(Supplier<T> var1, Supplier<T> var2);
}

