/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.jvoxelizer.item;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.ldtteam.jvoxelizer.block.state.IBlockState;
import com.ldtteam.jvoxelizer.client.model.IModelBiped;
import com.ldtteam.jvoxelizer.client.renderer.blockentity.IBlockEntityRenderer;
import com.ldtteam.jvoxelizer.client.renderer.font.IFontRenderer;
import com.ldtteam.jvoxelizer.common.animation.ITimedValue;
import com.ldtteam.jvoxelizer.core.logic.IInstancedObject;
import com.ldtteam.jvoxelizer.dimension.IDimension;
import com.ldtteam.jvoxelizer.enchantment.IEnchantment;
import com.ldtteam.jvoxelizer.entity.IEntity;
import com.ldtteam.jvoxelizer.entity.ai.IAttributeModifier;
import com.ldtteam.jvoxelizer.entity.item.IItemStackEntity;
import com.ldtteam.jvoxelizer.entity.living.ILivingBaseEntity;
import com.ldtteam.jvoxelizer.entity.living.ILivingEntity;
import com.ldtteam.jvoxelizer.entity.living.player.IPlayerEntity;
import com.ldtteam.jvoxelizer.entity.passive.IHorseArmorType;
import com.ldtteam.jvoxelizer.item.IItemPropertyGetter;
import com.ldtteam.jvoxelizer.item.IItemProviderHolder;
import com.ldtteam.jvoxelizer.item.IItemStack;
import com.ldtteam.jvoxelizer.item.group.IItemGroup;
import com.ldtteam.jvoxelizer.registries.IRegistryEntry;
import com.ldtteam.jvoxelizer.util.action.IActionType;
import com.ldtteam.jvoxelizer.util.actionresult.IActionResult;
import com.ldtteam.jvoxelizer.util.actionresult.IActionResultType;
import com.ldtteam.jvoxelizer.util.equipmentslot.IEquipmentSlot;
import com.ldtteam.jvoxelizer.util.facing.IFacing;
import com.ldtteam.jvoxelizer.util.hand.IHand;
import com.ldtteam.jvoxelizer.util.identifier.IIdentifier;
import com.ldtteam.jvoxelizer.util.math.coordinate.block.IBlockCoordinate;
import com.ldtteam.jvoxelizer.util.nbt.INBTCompound;
import com.ldtteam.jvoxelizer.util.rarity.IRarity;
import com.ldtteam.jvoxelizer.util.tooltipflag.IToolTipFlag;
import java.util.List;
import java.util.Set;

public interface IItem<I>
extends IRegistryEntry<IItem<I>>,
IInstancedObject<I> {
    public static int getIdFromItem(IItem<?> item) {
        return IItemProviderHolder.getInstance().provideIdFromItem(item);
    }

    public void addPropertyOverride(IIdentifier var1, IItemPropertyGetter var2);

    public IItemPropertyGetter getPropertyGetter(IIdentifier var1);

    public boolean updateItemStackNBT(INBTCompound var1);

    public boolean hasCustomProperties();

    public IActionResultType onItemUse(IPlayerEntity var1, IDimension var2, IBlockCoordinate var3, IHand var4, IFacing var5, float var6, float var7, float var8);

    public float getDestroySpeed(IItemStack var1, IBlockState var2);

    public IActionResult<IItemStack> onItemRightClick(IDimension var1, IPlayerEntity var2, IHand var3);

    public IItemStack onItemUseFinish(IItemStack var1, IDimension var2, ILivingBaseEntity var3);

    public boolean getHasSubtypes();

    public boolean isDamageable();

    public boolean hitEntity(IItemStack var1, ILivingBaseEntity var2, ILivingBaseEntity var3);

    public boolean onBlockDestroyed(IItemStack var1, IDimension var2, IBlockState var3, IBlockCoordinate var4, ILivingBaseEntity var5);

    public boolean canHarvestBlock(IBlockState var1);

    public boolean itemInteractionForEntity(IItemStack var1, IPlayerEntity var2, ILivingBaseEntity var3, IHand var4);

    public boolean isFull3D();

    public boolean shouldRotateAroundWhenRendering();

    public String getUnlocalizedNameInefficiently(IItemStack var1);

    public String getUnlocalizedName();

    public String getUnlocalizedName(IItemStack var1);

    public boolean getShareTag();

    public IItem<?> getRemainderItemAfterUse();

    public boolean hasContainerItem();

    public void onUpdate(IItemStack var1, IDimension var2, IEntity var3, int var4, boolean var5);

    public void onCreated(IItemStack var1, IDimension var2, IPlayerEntity var3);

    public boolean isMap();

    public IActionType getItemUseAction(IItemStack var1);

    public int getMaxItemUseDuration(IItemStack var1);

    public void onPlayerStoppedUsing(IItemStack var1, IDimension var2, ILivingBaseEntity var3, int var4);

    public void addInformation(IItemStack var1, IDimension var2, List<String> var3, IToolTipFlag var4);

    public String getItemStackDisplayName(IItemStack var1);

    public boolean hasEffect(IItemStack var1);

    public IRarity getRarity(IItemStack var1);

    public boolean isEnchantable(IItemStack var1);

    public int getItemEnchantability();

    public void getSubItems(IItemGroup<?> var1, List<IItemStack> var2);

    public IItemGroup<?> getItemGroup();

    public boolean canItemEditBlocks();

    public boolean getIsRepairable(IItemStack var1, IItemStack var2);

    public Multimap<String, IAttributeModifier> getItemAttributeModifiers(IEquipmentSlot var1);

    public Multimap<String, IAttributeModifier> getAttributeModifiers(IEquipmentSlot var1, IItemStack var2);

    public boolean onDroppedByPlayer(IItemStack var1, IPlayerEntity var2);

    public String getHighlightTip(IItemStack var1, String var2);

    public IActionResultType onItemUseFirst(IPlayerEntity var1, IDimension var2, IBlockCoordinate var3, IFacing var4, float var5, float var6, float var7, IHand var8);

    public boolean isRepairable();

    public INBTCompound getNBTShareTag(IItemStack var1);

    public void readNBTShareTag(IItemStack var1, INBTCompound var2);

    public boolean onBlockStartBreak(IItemStack var1, IBlockCoordinate var2, IPlayerEntity var3);

    public void onUsingTick(IItemStack var1, ILivingBaseEntity var2, int var3);

    public boolean onLeftClickEntity(IItemStack var1, IPlayerEntity var2, IEntity var3);

    public IItemStack getRemainderItemAfterUse(IItemStack var1);

    public boolean hasContainerItem(IItemStack var1);

    public int getEntityLifespan(IItemStack var1, IDimension var2);

    public boolean hasCustomEntity(IItemStack var1);

    public IEntity createEntity(IDimension var1, IEntity var2, IItemStack var3);

    public boolean onEntityItemUpdate(IItemStackEntity var1);

    public IItemGroup<?>[] getItemGroups();

    public float getSmeltingExperience(IItemStack var1);

    public boolean doesSneakBypassUse(IItemStack var1, IDimension var2, IBlockCoordinate var3, IPlayerEntity var4);

    public void onArmorTick(IDimension var1, IPlayerEntity var2, IItemStack var3);

    public boolean isValidArmor(IItemStack var1, IEquipmentSlot var2, IEntity var3);

    public IEquipmentSlot getEquipmentSlot(IItemStack var1);

    public boolean isBookEnchantable(IItemStack var1, IItemStack var2);

    public String getArmorTexture(IItemStack var1, IEntity var2, IEquipmentSlot var3, String var4);

    public IFontRenderer getFontRenderer(IItemStack var1);

    public IModelBiped getArmorModel(ILivingBaseEntity var1, IItemStack var2, IEquipmentSlot var3, IModelBiped var4);

    public boolean onEntitySwing(ILivingBaseEntity var1, IItemStack var2);

    public int getDamage(IItemStack var1);

    public boolean showDurabilityBar(IItemStack var1);

    public double getDurabilityForDisplay(IItemStack var1);

    public int getRGBDurabilityForDisplay(IItemStack var1);

    public int getMaxDamage(IItemStack var1);

    public boolean isDamaged(IItemStack var1);

    public void setDamage(IItemStack var1, int var2);

    public boolean canHarvestBlock(IBlockState var1, IItemStack var2);

    public int getItemStackLimit(IItemStack var1);

    public void setHarvestLevel(String var1, int var2);

    public Set<String> getToolClasses(IItemStack var1);

    public int getHarvestLevel(IItemStack var1, String var2, IPlayerEntity var3, IBlockState var4);

    public int getItemEnchantability(IItemStack var1);

    public boolean canApplyAtEnchantingTable(IItemStack var1, IEnchantment var2);

    public boolean isBeaconPayment(IItemStack var1);

    public boolean shouldCauseReequipAnimation(IItemStack var1, IItemStack var2, boolean var3);

    public boolean shouldCauseBlockBreakReset(IItemStack var1, IItemStack var2);

    public String getCreatorModId(IItemStack var1);

    public ImmutableMap<String, ITimedValue> getAnimationParameters(IItemStack var1, IDimension var2, ILivingBaseEntity var3);

    public boolean canDisableShield(IItemStack var1, IItemStack var2, ILivingBaseEntity var3, ILivingBaseEntity var4);

    public boolean isShield(IItemStack var1, ILivingBaseEntity var2);

    public int getItemBurnTime(IItemStack var1);

    public IHorseArmorType getHorseArmorType(IItemStack var1);

    public void onHorseArmorTick(IDimension var1, ILivingEntity var2, IItemStack var3);

    public IBlockEntityRenderer getBlockEntityItemStackRenderer();

    public IItemStack createDefaultItemStack();

    public String getTranslationKey(IItemStack var1);
}

