/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.jvoxelizer.entity;

import com.ldtteam.jvoxelizer.common.capability.provider.ICapabilityProvider;
import com.ldtteam.jvoxelizer.dimension.IDimension;
import com.ldtteam.jvoxelizer.entity.IEntityProviderHolder;
import com.ldtteam.jvoxelizer.util.math.coordinate.block.IBlockCoordinate;
import com.ldtteam.jvoxelizer.util.math.coordinate.entity.IEntityCoordinate;
import com.ldtteam.jvoxelizer.util.nbt.INBTSerializable;
import com.ldtteam.jvoxelizer.util.ticking.data.IReadOnlyTickingDataEntry;
import com.ldtteam.jvoxelizer.util.ticking.data.ITickingDataEntry;
import java.util.UUID;

public interface IEntity
extends INBTSerializable,
ICapabilityProvider {
    public static IEntity create(IDimension dimension) {
        return IEntityProviderHolder.getInstance().provide(dimension);
    }

    public static IEntity create(UUID id) {
        return IEntityProviderHolder.getInstance().provide(id);
    }

    public static IEntity create() {
        return IEntityProviderHolder.getInstance().provide();
    }

    public UUID getId();

    public boolean shouldEntitySpawn();

    public boolean shouldEntityForceSpawn();

    public int getDimension();

    public ITickingDataEntry<IEntityCoordinate> getPositionOfEntityOrigin();

    public ITickingDataEntry<IBlockCoordinate> getPositionOfBlockContainingEntity();

    public IReadOnlyTickingDataEntry<Float> getRotationYaw();

    public IReadOnlyTickingDataEntry<Float> getRotationPitch();

    public boolean isOnGround();

    public boolean hasCollidedHorizontally();

    public boolean hasCollidedVertically();

    default public boolean hasCollided() {
        return this.hasCollidedHorizontally() || this.hasCollidedVertically();
    }

    public boolean hasVelocityChanged();

    public boolean isDead();

    public float getWidth();

    public IReadOnlyTickingDataEntry<Float> getDistanceWalkedModified();

    public float getDistanceWalkedOnStepModified();

    public float getFallDistance();

    public IEntity setFallDistance(float var1);
}

