/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.jvoxelizer.core.logic;

import com.ldtteam.jvoxelizer.core.logic.IInstancedObject;
import com.ldtteam.jvoxelizer.core.logic.PipelineProcessor;
import java.util.List;
import java.util.function.Function;

public class TypedPipelineElementContext<T, R, O extends IInstancedObject<I>, I> {
    private final O instance;
    private final T context;
    private final List<Function<TypedPipelineElementContext<T, R, O, I>, R>> elements;
    private final PipelineProcessor.PipelineSuperFunction<TypedPipelineElementContext<T, R, O, I>, R> superCallback;
    private final int index;

    public TypedPipelineElementContext(O instance, T context, List<Function<TypedPipelineElementContext<T, R, O, I>, R>> elements, PipelineProcessor.PipelineSuperFunction<TypedPipelineElementContext<T, R, O, I>, R> superCallback) {
        this.instance = instance;
        this.context = context;
        this.elements = elements;
        this.superCallback = superCallback;
        this.index = 0;
    }

    public TypedPipelineElementContext(O instance, T context, List<Function<TypedPipelineElementContext<T, R, O, I>, R>> elements, PipelineProcessor.PipelineSuperFunction<TypedPipelineElementContext<T, R, O, I>, R> superCallback, int index) {
        this.instance = instance;
        this.context = context;
        this.elements = elements;
        this.superCallback = superCallback;
        this.index = index;
    }

    public O getInstance() {
        return this.instance;
    }

    public I getInstanceData() {
        return (I)this.getInstance().getInstanceData();
    }

    public T getContext() {
        return this.context;
    }

    public R next() {
        if (this.index == this.elements.size()) {
            return null;
        }
        return this.elements.get(this.index).apply(new TypedPipelineElementContext<T, R, O, I>(this.instance, this.context, this.elements, this.superCallback, this.index + 1));
    }

    public R callSuper() {
        try {
            return this.superCallback.apply(this);
        }
        catch (Exception e) {
            throw new IllegalStateException("Super exception in pipeline", e);
        }
    }
}

