/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.jvoxelizer.core.logic;

import com.ldtteam.jvoxelizer.core.logic.IInstancedObject;
import com.ldtteam.jvoxelizer.core.logic.TypedPipelineElementContext;
import com.ldtteam.jvoxelizer.core.logic.VoidPipelineElementContext;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public final class PipelineProcessor {
    private PipelineProcessor() {
        throw new IllegalStateException("Tried to initialize: PipelineProcessor but this is a Utility class.");
    }

    public static <T, G extends IInstancedObject<D>, D> void processVoidPipeline(G instance, T context, List<Consumer<VoidPipelineElementContext<T, G, D>>> pipeline, PipelineSuperCallback<T> superCallCallback) {
        if (pipeline.isEmpty()) {
            try {
                superCallCallback.apply(context);
            }
            catch (Exception e) {
                throw new IllegalStateException("Super exception in pipeline", e);
            }
            return;
        }
        VoidPipelineElementContext<T, G, D> voidPipelineElementContext = new VoidPipelineElementContext<T, G, D>(instance, context, pipeline, v -> superCallCallback.apply(v.getContext()));
        voidPipelineElementContext.next();
    }

    public static <T, R, G extends IInstancedObject<D>, D> R processTypedPipeline(G instance, T context, List<Function<TypedPipelineElementContext<T, R, G, D>, R>> pipeline, PipelineSuperFunction<T, R> superCallCallback) {
        if (pipeline.isEmpty()) {
            try {
                return superCallCallback.apply(context);
            }
            catch (Exception e) {
                throw new IllegalStateException("Super exception in pipeline", e);
            }
        }
        TypedPipelineElementContext typedPipelineElementContext = new TypedPipelineElementContext(instance, context, pipeline, v -> superCallCallback.apply(v.getContext()));
        return (R)typedPipelineElementContext.next();
    }

    @FunctionalInterface
    public static interface PipelineSuperFunction<T, R> {
        public R apply(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface PipelineSuperCallback<T> {
        public void apply(T var1) throws Exception;
    }
}

