/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.json.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;

public final class JSONStreamSupport {
    private JSONStreamSupport() {
        throw new IllegalArgumentException("Utility Class");
    }

    public static Stream<JsonElement> streamChildData(@NotNull JsonElement element) {
        if (element.isJsonArray()) {
            return JSONStreamSupport.streamArray(element.getAsJsonArray());
        }
        return Stream.builder().build();
    }

    public static Stream<JsonElement> streamArray(@NotNull JsonArray array) {
        return StreamSupport.stream(new JsonArraySpliterator(array), false);
    }

    public static Stream<Map.Entry<String, JsonElement>> streamObject(@NotNull JsonElement element) {
        if (!element.isJsonObject()) {
            return Stream.builder().build();
        }
        JsonObject object = element.getAsJsonObject();
        return object.entrySet().stream();
    }

    private static class JsonArraySpliterator
    implements Spliterator<JsonElement> {
        @NotNull
        private final JsonArray array;
        private int index = 0;

        public JsonArraySpliterator(@NotNull JsonArray array) {
            this.array = array;
        }

        @Override
        public boolean tryAdvance(Consumer<? super JsonElement> action) {
            if (this.index < this.array.size()) {
                action.accept((JsonElement)this.array.get(this.index++));
            }
            return this.index < this.array.size();
        }

        @Override
        public Spliterator<JsonElement> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return this.array.size() - (this.index + 1);
        }

        @Override
        public int characteristics() {
            return 1297;
        }
    }
}

