/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.ldtteam.blockout.element.IUIElementHost;
import com.ldtteam.blockout.json.JsonUIElementData;
import com.ldtteam.blockout.json.util.JSONStreamSupport;
import com.ldtteam.blockout.loader.core.IUIElementData;
import com.ldtteam.blockout.loader.core.component.ComponentType;
import com.ldtteam.blockout.loader.core.component.IUIElementDataComponent;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonUIElementDataComponent
implements IUIElementDataComponent {
    @NotNull
    private JsonElement element;

    JsonUIElementDataComponent(@NotNull JsonElement element) {
        this.element = element;
    }

    public String getAsString() {
        return this.element.isJsonPrimitive() ? this.element.getAsString() : "";
    }

    public Boolean getAsBoolean() {
        return this.element.getAsBoolean();
    }

    public void setBoolean(@NotNull Boolean bool) throws IllegalArgumentException {
        this.element = new JsonPrimitive(bool);
    }

    public Integer getAsInteger() {
        return this.element.getAsInt();
    }

    public void setInteger(@NotNull Integer integer) throws IllegalArgumentException {
        this.element = new JsonPrimitive((Number)integer);
    }

    public Double getAsDouble() {
        return this.element.getAsDouble();
    }

    public void setDouble(@NotNull Double d) throws IllegalArgumentException {
        this.element = new JsonPrimitive((Number)d);
    }

    public Float getAsFloat() {
        return Float.valueOf(this.element.getAsFloat());
    }

    public void setFloat(@NotNull Float f) throws IllegalArgumentException {
        this.element = new JsonPrimitive((Number)f);
    }

    public List<IUIElementDataComponent> getAsList() {
        return JSONStreamSupport.streamChildData(this.element).map(element1 -> new JsonUIElementDataComponent((JsonElement)element1)).collect(Collectors.toList());
    }

    public Map<String, IUIElementDataComponent> getAsMap() {
        return JSONStreamSupport.streamObject(this.element).collect(Collectors.toMap(Map.Entry::getKey, e -> new JsonUIElementDataComponent((JsonElement)e.getValue())));
    }

    public void setMap(@NotNull Map<String, ? extends IUIElementDataComponent> map) throws IllegalArgumentException {
        this.element = new JsonObject();
        map.entrySet().stream().filter(e -> e.getValue() instanceof JsonUIElementDataComponent).forEach(e -> ((JsonObject)this.element).add((String)e.getKey(), ((JsonUIElementDataComponent)e.getValue()).element));
    }

    public IUIElementData<?> toIUIElementData(@Nullable IUIElementHost parent) {
        if (!this.isComplex()) {
            throw new IllegalStateException("Need complex Json Object for UIElementData.");
        }
        return new JsonUIElementData(this.element.getAsJsonObject(), parent);
    }

    public void setString(@NotNull String string) throws IllegalArgumentException {
        this.element = new JsonPrimitive(string);
    }

    public ComponentType getType() {
        if (this.element.isJsonObject()) {
            return ComponentType.COMPLEX;
        }
        if (this.element.isJsonArray()) {
            return ComponentType.LIST;
        }
        if (this.element.isJsonPrimitive()) {
            JsonPrimitive primitive = (JsonPrimitive)this.element;
            if (primitive.isBoolean()) {
                return ComponentType.BOOL;
            }
            if (primitive.isNumber()) {
                return ComponentType.NUMBER;
            }
            return ComponentType.STRING;
        }
        return ComponentType.UNKNOWN;
    }

    public void setList(@NotNull List<? extends IUIElementDataComponent> list) throws IllegalArgumentException {
        this.element = new JsonArray();
        list.stream().filter(e -> e instanceof JsonUIElementDataComponent).forEach(e -> ((JsonArray)this.element).add(((JsonUIElementDataComponent)e).element));
    }
}

