/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.render;

import cd4017be.lib.event.ModTextureStitchEvent;
import java.io.IOException;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RectangularSprite
extends TextureAtlasSprite {
    static boolean STITCHING = true;
    boolean imgTransposed;

    public RectangularSprite(String spriteName) {
        super(spriteName);
    }

    public void func_188538_a(PngSizeInfo sizeInfo, boolean p_188538_2_) throws IOException {
        try {
            super.func_188538_a(sizeInfo, p_188538_2_);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void func_110971_a(int inX, int inY, int originInX, int originInY, boolean rotatedIn) {
        int w = this.field_130223_c;
        int h = this.field_130224_d;
        if (rotatedIn) {
            this.field_130223_c = h;
            this.field_130224_d = w;
            super.func_110971_a(inX, inY, originInX, originInY, rotatedIn);
            this.field_130223_c = w;
            this.field_130224_d = h;
        } else {
            super.func_110971_a(inX, inY, originInX, originInY, rotatedIn);
        }
        if (rotatedIn ^ this.imgTransposed) {
            int[][] arr = (int[][])this.field_110976_a.get(0);
            for (int i = 0; i < arr.length; ++i) {
                int[] img = arr[i];
                int[] ri = new int[img.length];
                int l = 0;
                for (int j = 0; j < w; ++j) {
                    int k = 0;
                    while (k < h) {
                        ri[l] = img[w * k + j];
                        ++k;
                        ++l;
                    }
                }
                arr[i] = ri;
            }
            this.imgTransposed = rotatedIn;
        }
    }

    public int func_94211_a() {
        return STITCHING && this.field_130222_e ? this.field_130224_d : this.field_130223_c;
    }

    public int func_94216_b() {
        return STITCHING && this.field_130222_e ? this.field_130223_c : this.field_130224_d;
    }

    public boolean uvTransposed() {
        return this.imgTransposed;
    }

    public static float[] getInterpolatedUV(float[] a, TextureAtlasSprite tex, float u, float v, float w, float h) {
        float o;
        int t;
        if (a == null) {
            a = new float[8];
        }
        if (tex instanceof RectangularSprite && ((RectangularSprite)tex).imgTransposed) {
            t = 4;
            o = u;
            u = v;
            v = o;
            o = w;
            w = h;
            h = o;
        } else {
            t = 0;
        }
        o = tex.func_94209_e();
        float d = tex.func_94212_f() - o;
        a[0] = u = u * d + o;
        a[4] = w * d + o + u;
        o = tex.func_94206_g();
        d = tex.func_94210_h() - o;
        a[1] = v = v * d + o;
        a[5] = h * d + o + v;
        a[2] = a[0 ^ t];
        a[6] = a[4 ^ t];
        a[3] = a[5 ^ t];
        a[7] = a[1 ^ t];
        return a;
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
    }

    static class EventHandler {
        EventHandler() {
        }

        @SubscribeEvent
        void preStitch(TextureStitchEvent.Pre event) {
            STITCHING = true;
        }

        @SubscribeEvent
        void postStitch(TextureStitchEvent.Post event) {
            STITCHING = false;
        }

        @SubscribeEvent
        void preStitch(ModTextureStitchEvent.Pre event) {
            STITCHING = true;
        }

        @SubscribeEvent
        void postStitch(ModTextureStitchEvent.Post event) {
            STITCHING = false;
        }
    }
}

