/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.network;

import cd4017be.lib.network.StateSynchronizer;
import cd4017be.lib.util.ItemFluidUtil;
import java.io.IOException;
import java.util.BitSet;
import java.util.UUID;
import li.cil.oc.common.block.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;

public class StateSyncClient
extends StateSynchronizer {
    public PacketBuffer buffer;
    private final int fixCount;
    private int elIdx;

    public StateSyncClient(int count, int ... sizes) {
        super(count, sizes);
        this.fixCount = sizes.length;
    }

    public StateSyncClient decodePacket(PacketBuffer buf) {
        if ((buf.getByte(buf.readerIndex()) & 1) == 0) {
            byte[] arr = new byte[this.modSetBytes];
            buf.readBytes(arr);
            this.changes = BitSet.valueOf(arr);
        } else {
            int j = this.idxCountBits + 1;
            int b = this.idxBits;
            int mask = 65535 >> 16 - b;
            int v = j <= 8 ? buf.readUnsignedByte() : buf.readUnsignedShortLE();
            int cc = (v & 65535 >> 16 - j) >> 1;
            BitSet chng = this.changes;
            chng.clear();
            v >>= j;
            j = -j & 7;
            for (int i = 0; i < cc; ++i) {
                if (j < b) {
                    if (j < b - 8) {
                        v |= buf.readUnsignedShortLE() << j;
                        j += 16;
                    } else {
                        v |= buf.readUnsignedByte() << j;
                        j += 8;
                    }
                }
                chng.set((v & mask) + 1);
                v >>= b;
                j -= b;
            }
        }
        this.buffer = buf;
        this.elIdx = 0;
        return this;
    }

    public boolean next() {
        return this.changes.get(++this.elIdx);
    }

    public int get(int old) {
        int i;
        if (this.changes.get(i = ++this.elIdx)) {
            switch (this.sizes[i - 1]) {
                case 4: {
                    return this.buffer.readInt();
                }
                case 3: {
                    return this.buffer.readMedium();
                }
                case 2: {
                    return this.buffer.readShort();
                }
                case 1: {
                    return this.buffer.readByte();
                }
            }
            throw new IllegalStateException("wrong element!");
        }
        return old;
    }

    public long get(long old) {
        return this.changes.get(++this.elIdx) ? this.buffer.readLong() : old;
    }

    public float get(float old) {
        return this.changes.get(++this.elIdx) ? this.buffer.readFloat() : old;
    }

    public double get(double old) {
        return this.changes.get(++this.elIdx) ? this.buffer.readDouble() : old;
    }

    public byte[] get(byte[] old) {
        int i = this.elIdx;
        if (i < this.fixCount) {
            int[] sizes = this.sizes;
            BitSet chng = this.changes;
            PacketBuffer buf = this.buffer;
            int l = old.length;
            int j = 0;
            while (j < l) {
                int n = sizes[i];
                if (chng.get(i + 1)) {
                    buf.readBytes(old, j, n);
                }
                j += n;
                ++i;
            }
            this.elIdx = i;
        } else {
            this.elIdx = i + 1;
            if (this.changes.get(this.elIdx)) {
                return this.buffer.func_179251_a();
            }
        }
        return old;
    }

    public int[] get(int[] old) {
        int i = this.elIdx;
        if (i < this.fixCount) {
            int[] sizes = this.sizes;
            BitSet chng = this.changes;
            PacketBuffer buf = this.buffer;
            int l = old.length;
            int j = 0;
            while (j < l) {
                int n = sizes[i];
                if ((n & 3) != 0) {
                    throw new IllegalStateException("int array element size is " + n + " but must be multiple of 4!");
                }
                if (chng.get(i + 1)) {
                    n >>= 2;
                    while (n > 0) {
                        old[j] = buf.readInt();
                        --n;
                        ++j;
                    }
                } else {
                    j += n >> 2;
                }
                ++i;
            }
            this.elIdx = i;
        } else {
            this.elIdx = i + 1;
            if (this.changes.get(this.elIdx)) {
                return this.buffer.func_186863_b();
            }
        }
        return old;
    }

    public String get(String old) {
        return this.changes.get(++this.elIdx) ? this.buffer.func_150789_c(Short.MAX_VALUE) : old;
    }

    public <V extends Enum<V>> V get(V old, Class<V> type) {
        int v0 = old == null ? -1 : old.ordinal();
        int v1 = this.get(v0);
        if (v1 == v0) {
            return old;
        }
        Enum[] values = (Enum[])type.getEnumConstants();
        return (V)(v1 >= 0 && v1 < values.length ? values[v1] : null);
    }

    public BlockPos get(BlockPos old) {
        return this.changes.get(++this.elIdx) ? this.buffer.func_179259_c() : old;
    }

    public UUID get(UUID old) {
        return this.changes.get(++this.elIdx) ? this.buffer.func_179253_g() : old;
    }

    public ItemStack get(ItemStack old) throws IOException {
        if (this.changes.get(++this.elIdx)) {
            PacketBuffer buf = this.buffer;
            short id = buf.readShort();
            if (id < 0) {
                return ItemStack.field_190927_a;
            }
            int n = buf.readInt();
            short m = buf.readShort();
            ItemStack stack = new ItemStack(Item.func_150899_d((int)id), n, (int)m);
            stack.func_77982_d(buf.func_150793_b());
            return stack;
        }
        return old;
    }

    public FluidStack get(FluidStack old) throws IOException {
        if (this.changes.get(++this.elIdx)) {
            return ItemFluidUtil.readFluidStack(this.buffer);
        }
        return old;
    }
}

