/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.item;

import cd4017be.lib.BlockItemRegistry;
import cd4017be.lib.item.BaseItem;
import cd4017be.lib.util.TooltipUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class ItemMaterial
extends BaseItem {
    public HashMap<Integer, Variant> variants = new HashMap();

    public ItemMaterial(String id) {
        super(id);
        this.func_77627_a(true);
    }

    @Override
    protected void init() {
    }

    @Override
    public String func_77667_c(ItemStack item) {
        Variant name = this.variants.get(item.func_77952_i());
        return this.func_77658_a() + (name == null ? "" : ":" + name);
    }

    @Override
    public String func_77653_i(ItemStack item) {
        Variant name = this.variants.get(item.func_77952_i());
        if (name != null) {
            return name.getLocName();
        }
        return TooltipUtil.translate(this.func_77658_a());
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        ItemMaterial item = this;
        subItems.add((Object)new ItemStack((Item)this, 1, 0));
        int[] ids = new int[this.variants.size()];
        int n = 0;
        Iterator<Integer> iterator = this.variants.keySet().iterator();
        while (iterator.hasNext()) {
            int i = iterator.next();
            ids[n++] = i;
        }
        Arrays.sort(ids);
        for (Object i : (Iterator<Integer>)ids) {
            subItems.add((Object)new ItemStack((Item)item, 1, (int)i));
        }
    }

    public void addMaterial(int id, String name, String model, String locName) {
        if (id <= 0 || id >= 32768 || this.variants.containsKey(id)) {
            throw new IllegalArgumentException("Id already occupied or out of range!");
        }
        this.variants.put(id, new Variant(name, locName, model == null ? null : new ResourceLocation(model)));
        BlockItemRegistry.registerItemStack(new ItemStack((Item)this, 1, id), this.getRegistryName().func_110623_a() + "." + name);
    }

    public class Variant {
        public final String name;
        public final String locName;
        public final ResourceLocation model;

        public Variant(String name, String locName, ResourceLocation model) {
            this.name = name;
            this.locName = locName;
            this.model = model != null ? model : new ResourceLocation(ItemMaterial.this.getRegistryName().toString() + "/" + name);
        }

        public String getLocName() {
            if (this.locName != null) {
                return this.locName;
            }
            return TooltipUtil.translate(ItemMaterial.this.func_77658_a() + ":" + this.name + ".name");
        }

        public String toString() {
            return this.name;
        }
    }
}

