/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.Gui.comp;

import cd4017be.lib.Gui.ITankContainer;
import cd4017be.lib.Gui.ModularGui;
import cd4017be.lib.Gui.TileContainer;
import cd4017be.lib.Gui.comp.GuiCompBase;
import cd4017be.lib.Gui.comp.GuiCompGroup;
import cd4017be.lib.util.TooltipUtil;
import java.util.ArrayList;
import java.util.function.IntConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.config.GuiUtils;

public class TankInterface
extends GuiCompBase<GuiCompGroup> {
    private final ITankContainer inv;
    private final int slot;
    private final IntConsumer handler;

    public TankInterface(GuiCompGroup parent, TileContainer.TankSlot slot, @Nullable IntConsumer handler) {
        this(parent, (slot.size >> 4 & 0xF) * 18 - 2, (slot.size & 0xF) * 18 - 2, slot.xPos, slot.yPos, slot.inventory, slot.tankNumber, handler);
    }

    public TankInterface(GuiCompGroup parent, int w, int h, int x, int y, ITankContainer inv, int slot, @Nullable IntConsumer handler) {
        super(parent, w, h, x, y);
        this.inv = inv;
        this.slot = slot;
        this.handler = handler;
    }

    @Override
    public void drawOverlay(int mx, int my) {
        FluidStack stack = this.inv.getTank(this.slot);
        ArrayList<String> info = new ArrayList<String>();
        info.add(stack != null ? stack.getLocalizedName() : TooltipUtil.translate("cd4017be.tankEmpty"));
        info.add(TooltipUtil.format("cd4017be.tankAmount", stack != null ? (double)stack.amount / 1000.0 : 0.0, (double)this.inv.getCapacity(this.slot) / 1000.0));
        this.parent.drawTooltip(info, mx, my);
    }

    @Override
    public void drawBackground(int mx, int my, float t) {
        ResourceLocation res;
        GlStateManager.func_179118_c();
        FluidStack stack = this.inv.getTank(this.slot);
        if (stack != null && ((res = stack.getFluid().getStill(stack)) != null || (res = stack.getFluid().getFlowing(stack)) != null)) {
            int c = this.inv.getCapacity(this.slot);
            int n = c == 0 || stack.amount >= c ? this.h : (int)((long)this.h * (long)stack.amount / (long)c);
            ModularGui.color(stack.getFluid().getColor(stack));
            Minecraft mc = Minecraft.func_71410_x();
            TextureAtlasSprite tex = mc.func_147117_R().func_110572_b(res.toString());
            float u = tex.func_94209_e();
            float v = tex.func_94206_g();
            this.parent.bindTexture(TextureMap.field_110575_b);
            GuiScreen.func_146110_a((int)this.x, (int)(this.y + this.h - n), (float)u, (float)v, (int)this.w, (int)n, (float)(tex.func_94212_f() - u), (float)(tex.func_94210_h() - v));
        }
        ModularGui.color(-1);
        this.parent.bindTexture(ModularGui.LIB_TEX);
        GuiUtils.drawTexturedModalRect((int)(this.x + this.w - 16), (int)this.y, (int)110, (int)(52 - this.h), (int)16, (int)this.h, (float)this.parent.zLevel);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
    }

    @Override
    public boolean mouseIn(int x, int y, int b, byte d) {
        if (d == 0 && this.handler != null) {
            this.handler.accept(this.slot);
        }
        return false;
    }
}

