/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.Gui;

import cd4017be.lib.Gui.HidableSlot;
import cd4017be.lib.Gui.ISpecialSlot;
import cd4017be.lib.Gui.LockedSlot;
import cd4017be.lib.Gui.SlotArmor;
import cd4017be.lib.Gui.SlotOffhand;
import cd4017be.lib.network.GuiNetworkHandler;
import cd4017be.lib.network.IPlayerPacketReceiver;
import cd4017be.lib.network.IServerPacketReceiver;
import cd4017be.lib.network.StateSyncClient;
import cd4017be.lib.network.StateSyncServer;
import cd4017be.lib.network.StateSynchronizer;
import cd4017be.lib.util.Utils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class AdvancedContainer
extends Container
implements IServerPacketReceiver,
IPlayerPacketReceiver {
    public final IStateInteractionHandler handler;
    public final StateSynchronizer sync;
    public final EntityPlayer player;
    private final IntArrayList slotsToSync;
    public final ArrayList<IQuickTransferHandler> transferHandlers;
    private boolean sorted = true;
    private boolean hardInvUpdate = false;
    private int playerInvS;
    private int playerInvE;

    public AdvancedContainer(IStateInteractionHandler handler, StateSynchronizer sync, EntityPlayer player) {
        this.handler = handler;
        this.sync = sync;
        this.player = player;
        this.slotsToSync = new IntArrayList();
        this.transferHandlers = new ArrayList();
    }

    public void func_75142_b() {
        if (this.player.field_70170_p.field_72995_K) {
            super.func_75142_b();
            return;
        }
        StateSyncServer sss = (StateSyncServer)this.sync;
        sss.buffer.clear().writeInt(this.field_75152_c);
        sss.setHeader();
        this.handler.writeState(sss.begin(), this);
        this.writeItems(sss);
        PacketBuffer pkt = sss.encodePacket();
        if (pkt != null) {
            GuiNetworkHandler.GNH_INSTANCE.sendToPlayer(pkt, (EntityPlayerMP)this.player);
        }
    }

    private void writeItems(StateSyncServer sss) {
        if (this.hardInvUpdate && this.player instanceof EntityPlayerMP) {
            ((EntityPlayerMP)this.player).field_71137_h = false;
            this.hardInvUpdate = false;
        }
        if (this.slotsToSync.isEmpty()) {
            super.func_75142_b();
            return;
        }
        int n = this.slotsToSync.size();
        int o = sss.count - n;
        int[] syncList = this.slotsToSync.elements();
        if (!this.sorted) {
            IntArrays.quickSort((int[])syncList, (int)0, (int)n);
            this.sorted = true;
        }
        boolean init = sss.sendAll;
        int l = this.field_75151_b.size();
        for (int i = 0; i < l; ++i) {
            int p;
            Slot slot = (Slot)this.field_75151_b.get(i);
            ItemStack itemN = slot.func_75211_c();
            ItemStack itemO = (ItemStack)this.field_75153_a.get(i);
            if (!ItemStack.func_77989_b((ItemStack)itemO, (ItemStack)itemN)) {
                boolean send = !ItemStack.areItemStacksEqualUsingNBTShareTag((ItemStack)itemN, (ItemStack)itemO);
                itemO = itemN.func_190926_b() ? ItemStack.field_190927_a : itemN.func_77946_l();
                this.field_75153_a.set(i, (Object)itemO);
                if (send) {
                    int p2 = IntArrays.binarySearch((int[])syncList, (int)0, (int)n, (int)i);
                    if (p2 >= 0) {
                        sss.set(p2 + o, itemO);
                        continue;
                    }
                    for (IContainerListener listener : this.field_75149_d) {
                        listener.func_71111_a((Container)this, i, itemO);
                    }
                    continue;
                }
            }
            if (!init || (p = IntArrays.binarySearch((int[])syncList, (int)0, (int)n, (int)i)) < 0) continue;
            sss.set(p + o, itemN);
        }
    }

    public void func_75132_a(IContainerListener listener) {
        if (listener instanceof EntityPlayerMP) {
            ((StateSyncServer)this.sync).setInitPkt();
        }
        super.func_75132_a(listener);
    }

    public void addPlayerInventory(int x, int y) {
        this.addPlayerInventory(x, y, false, false);
    }

    public void addPlayerInventory(int x, int y, boolean armor, boolean lockSel) {
        int i;
        this.playerInvS = this.field_75151_b.size();
        this.playerInvE = this.playerInvS + (armor ? 41 : 36);
        InventoryPlayer inv = this.player.field_71071_by;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new HidableSlot((IInventory)inv, i * 9 + j + 9, x + j * 18, y + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            if (lockSel && i == inv.field_70461_c) {
                this.func_75146_a(new LockedSlot((IInventory)inv, i, x + i * 18, y + 58));
                continue;
            }
            this.func_75146_a(new HidableSlot((IInventory)inv, i, x + i * 18, y + 58));
        }
        if (armor) {
            this.func_75146_a(new SlotOffhand((IInventory)inv, 40, x - 18, y + 58));
            for (i = 0; i < 4; ++i) {
                this.func_75146_a(new SlotArmor(inv, i + 36, x - 18, y - i * 18 + 36, EntityEquipmentSlot.values()[i + 2]));
            }
        }
    }

    public void addItemSlot(Slot slot, boolean sync) {
        if (sync) {
            this.slotsToSync.add(this.field_75151_b.size());
            this.sorted = false;
            if (this.player.field_70170_p.field_72995_K) {
                // empty if block
            }
        }
        this.func_75146_a(slot);
    }

    public void func_75141_a(int slotID, ItemStack stack) {
        if (this.slotsToSync.contains(slotID)) {
            return;
        }
        Slot slot = (Slot)this.field_75151_b.get(slotID);
        if (slot instanceof ISpecialSlot) {
            ((ISpecialSlot)slot).setStack(stack);
        } else {
            slot.func_75215_d(stack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190896_a(List<ItemStack> items) {
        int m = Math.min(items.size(), this.field_75151_b.size());
        for (int i = 0; i < m; ++i) {
            this.func_75141_a(i, items.get(i));
        }
    }

    @Override
    public void handlePlayerPacket(PacketBuffer pkt, EntityPlayerMP sender) throws Exception {
        this.handler.handleAction(pkt, sender);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleServerPacket(PacketBuffer pkt) throws Exception {
        StateSyncClient ssc = ((StateSyncClient)this.sync).decodePacket(pkt);
        this.handler.readState(ssc, this);
        IntListIterator intListIterator = this.slotsToSync.iterator();
        while (intListIterator.hasNext()) {
            int i = (Integer)intListIterator.next();
            Slot slot = (Slot)this.field_75151_b.get(i);
            ItemStack stack0 = slot.func_75211_c();
            ItemStack stack = ssc.get(stack0);
            if (stack == stack0) continue;
            if (slot instanceof ISpecialSlot) {
                ((ISpecialSlot)slot).setStack(stack);
                continue;
            }
            slot.func_75215_d(stack);
        }
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return this.handler.canInteract(playerIn, this);
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        this.handler.onCloseInteraction(playerIn, this);
    }

    public void hardInvUpdate() {
        this.hardInvUpdate = true;
    }

    public boolean hasPlayerInv() {
        return this.playerInvS != this.playerInvE;
    }

    public int playerInvStart() {
        return this.playerInvS;
    }

    public boolean func_75135_a(ItemStack item, int ss, int se, boolean d) {
        Slot slot;
        int i;
        ItemStack item1 = item.func_77946_l();
        if (item1.func_77985_e()) {
            for (i = se - ss; i > 0 && item1.func_190916_E() > 0; --i) {
                int mxs;
                slot = (Slot)this.field_75151_b.get(d ? i + ss - 1 : se - i);
                ItemStack stack = slot.func_75211_c();
                if (stack.func_190926_b()) continue;
                if (slot instanceof ISpecialSlot) {
                    ISpecialSlot s = (ISpecialSlot)slot;
                    if ((item1 = s.insertItem(item1, false)).func_190926_b()) {
                        item.func_190920_e(0);
                        return true;
                    }
                    if (!s.insertHereOnly(item1)) continue;
                    item.func_190920_e(item1.func_190916_E());
                    return true;
                }
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)item1)) continue;
                int j = stack.func_190916_E() + item1.func_190916_E();
                if (j <= (mxs = Math.min(item1.func_77976_d(), slot.func_75219_a()))) {
                    item.func_190920_e(0);
                    stack.func_190920_e(j);
                    slot.func_75218_e();
                    return true;
                }
                if (stack.func_190916_E() >= mxs) continue;
                item1.func_190918_g(mxs - stack.func_190916_E());
                stack.func_190920_e(mxs);
                slot.func_75218_e();
            }
        }
        if (item1.func_190916_E() > 0) {
            for (i = se - ss; i > 0; --i) {
                slot = (Slot)this.field_75151_b.get(d ? i + ss - 1 : se - i);
                if (slot.func_75211_c().func_190916_E() != 0) continue;
                if (slot instanceof ISpecialSlot) {
                    ISpecialSlot s = (ISpecialSlot)slot;
                    if ((item1 = s.insertItem(item1, false)).func_190916_E() == 0) {
                        item.func_190920_e(0);
                        return true;
                    }
                    if (!s.insertHereOnly(item1)) continue;
                    item.func_190920_e(item1.func_190916_E());
                    return true;
                }
                if (!slot.func_75214_a(item1)) continue;
                int mxs = slot.func_178170_b(item1);
                if (item1.func_190916_E() <= mxs) {
                    slot.func_75215_d(item1.func_77946_l());
                    slot.func_75218_e();
                    item.func_190920_e(0);
                    return true;
                }
                slot.func_75215_d(item1.func_77979_a(mxs));
                slot.func_75218_e();
            }
        }
        if (item1.func_190916_E() != item.func_190916_E()) {
            item.func_190920_e(item1.func_190916_E());
            return true;
        }
        return false;
    }

    public ItemStack func_82846_b(EntityPlayer player, int id) {
        Slot slot = (Slot)this.field_75151_b.get(id);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = slot.func_75211_c();
        ItemStack item = stack.func_77946_l();
        if (id >= this.playerInvS && id < this.playerInvE) {
            for (IQuickTransferHandler h : this.transferHandlers) {
                if (h.transfer(stack, this)) break;
            }
        } else {
            this.func_75135_a(stack, this.playerInvS, this.playerInvE, false);
        }
        if (stack.func_190916_E() == item.func_190916_E()) {
            return ItemStack.field_190927_a;
        }
        slot.func_75220_a(stack, item);
        slot.func_75218_e();
        slot.func_190901_a(player, stack);
        return item;
    }

    public ItemStack func_184996_a(int s, int b, ClickType m, EntityPlayer player) {
        Slot slot;
        Slot slot2 = slot = s >= 0 && s < this.field_75151_b.size() ? (Slot)this.field_75151_b.get(s) : null;
        if (slot instanceof ISpecialSlot) {
            ISpecialSlot ss = (ISpecialSlot)slot;
            return ss.onClick(b, m, player, this);
        }
        return super.func_184996_a(s, b, m, player);
    }

    @FunctionalInterface
    public static interface IQuickTransferHandler {
        public boolean transfer(ItemStack var1, AdvancedContainer var2);
    }

    public static interface IStateInteractionHandler {
        public void writeState(StateSyncServer var1, AdvancedContainer var2);

        public void readState(StateSyncClient var1, AdvancedContainer var2);

        default public void handleAction(PacketBuffer pkt, EntityPlayerMP sender) throws Exception {
        }

        public boolean canInteract(EntityPlayer var1, AdvancedContainer var2);

        default public void onCloseInteraction(EntityPlayer player, AdvancedContainer cont) {
        }

        default public BlockPos pos() {
            return Utils.NOWHERE;
        }
    }
}

