/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.rs_ctr.port;

import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.Link;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;

public class Port
implements INBTSerializable<NBTTagCompound>,
Comparable<Object> {
    public final IPortProvider owner;
    public final int pin;
    public final boolean isMaster;
    public final Class<?> type;
    protected int linkID = 0;

    public int getLink() {
        return this.linkID;
    }

    public Port(IPortProvider owner, int pin, Class<?> type, boolean isSource) {
        this.owner = owner;
        this.pin = pin;
        this.type = type;
        this.isMaster = isSource;
    }

    public void onLoad() {
        if (this.linkID == 0) {
            return;
        }
        Link l = (Link)Link.links.get(this.linkID);
        if (l == null) {
            Link.links.put(this.linkID, (Object)new Link(this));
        } else {
            l.load(this);
        }
    }

    public void onUnload() {
        Link l = (Link)Link.links.get(this.linkID);
        if (l != null) {
            l.unload(this);
        }
    }

    public void connect(Port to) {
        if (this.linkID != 0) {
            this.disconnect();
        }
        if (to.linkID != 0) {
            to.disconnect();
        }
        if (this.isMaster) {
            new Link(this, to);
        } else {
            new Link(to, this);
        }
    }

    public void disconnect() {
        Link l = (Link)Link.links.get(this.linkID);
        if (l != null) {
            l.disconnect();
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("link", this.linkID);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.linkID = nbt.func_74762_e("link");
    }

    public BlockPos getPos() {
        return this.owner instanceof TileEntity ? ((TileEntity)this.owner).func_174877_v() : (this.owner instanceof Entity ? ((Entity)this.owner).func_180425_c() : null);
    }

    public World getWorld() {
        return this.owner instanceof TileEntity ? ((TileEntity)this.owner).func_145831_w() : (this.owner instanceof Entity ? ((Entity)this.owner).field_70170_p : null);
    }

    @Override
    public int compareTo(Object o) {
        return this.pin - (o instanceof Port ? ((Port)o).pin : (Integer)o);
    }
}

