/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.protect;

import cd4017be.api.protect.IProtectionHandler;
import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CachedChunkWrapper
implements IProtectionHandler {
    private HashMap<Key, Boolean> cache = new HashMap();
    private final IProtectionHandler parent;

    public CachedChunkWrapper(IProtectionHandler parent) {
        this.parent = parent;
    }

    public void refresh() {
        this.cache.clear();
    }

    @Override
    public boolean canEdit(World world, BlockPos pos, GameProfile player) {
        return this.canEdit(new Key(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4, world.field_73011_w.getDimension(), player), world);
    }

    @Override
    public boolean canEdit(World world, BlockPos p0, BlockPos p1, GameProfile player) {
        int z1;
        int z0;
        int x1;
        int dim = world.field_73011_w.getDimension();
        int x0 = p0.func_177958_n() >> 4;
        if (x0 > (x1 = p1.func_177958_n() >> 4)) {
            int x = x0;
            x0 = x1;
            x1 = x;
        }
        if ((z0 = p0.func_177952_p() >> 4) > (z1 = p1.func_177952_p() >> 4)) {
            int z = z0;
            z0 = z1;
            z1 = z;
        }
        for (int x = x0; x <= x1; ++x) {
            for (int z = z0; z <= z1; ++z) {
                if (this.canEdit(new Key(x, z, dim, player), world)) continue;
                return false;
            }
        }
        return true;
    }

    boolean canEdit(Key key, World world) {
        Boolean perm = this.cache.get(key);
        if (perm == null) {
            perm = this.parent.canEdit(world, new BlockPos(key.cx << 4, 0, key.cz << 4), new BlockPos(key.cx << 4 | 0xF, 255, key.cz << 4 | 0xF), key.player);
            this.cache.put(key, perm);
        }
        return perm;
    }

    static class Key {
        final int cx;
        final int cz;
        final int dim;
        final GameProfile player;

        Key(int cx, int cz, int dim, GameProfile player) {
            this.cx = cx;
            this.cz = cz;
            this.dim = dim;
            this.player = player;
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.cx;
            result = 31 * result + this.cz;
            result = 31 * result + this.dim;
            result = 31 * result + this.player.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Key) {
                Key other = (Key)obj;
                return this.cx == other.cx && this.cz == other.cz && this.dim == other.dim && this.player.equals((Object)other.player);
            }
            return false;
        }
    }
}

