/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.network.tile.client;

import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import net.minecraft.util.math.BlockPos;

class TileDataTrackerUpdateMonitor {
    private static final int TRACKER_UPDATE_INTERVAL_TICKS = 20;
    private final Object2ObjectArrayMap<BlockPos, Object2IntArrayMap<Class>> privateTrackerUpdateMap = new Object2ObjectArrayMap();
    private final Object2ObjectArrayMap<BlockPos, Object2IntArrayMap<Class>> publicTrackerUpdateMap = new Object2ObjectArrayMap();
    private int updateCounter;

    TileDataTrackerUpdateMonitor() {
    }

    void update() {
        ++this.updateCounter;
        if (this.updateCounter >= 20) {
            this.updateCounter = 0;
            this.publicTrackerUpdateMap.clear();
            ObjectIterator iterator = this.privateTrackerUpdateMap.object2ObjectEntrySet().fastIterator();
            while (iterator.hasNext()) {
                Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)iterator.next();
                this.publicTrackerUpdateMap.put(entry.getKey(), entry.getValue());
            }
            this.privateTrackerUpdateMap.clear();
        }
    }

    void onClientTrackerUpdateReceived(BlockPos pos, Class<? extends ITileData> tileDataClass) {
        Object2IntArrayMap map = (Object2IntArrayMap)this.privateTrackerUpdateMap.computeIfAbsent((Object)pos, blockPos -> {
            Object2IntArrayMap newMap = new Object2IntArrayMap();
            newMap.defaultReturnValue(0);
            return newMap;
        });
        map.put(tileDataClass, map.getInt(tileDataClass) + 1);
    }

    Object2ObjectArrayMap<BlockPos, Object2IntArrayMap<Class>> getPublicTrackerUpdateMap() {
        return this.publicTrackerUpdateMap;
    }
}

