/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.network.tile;

import com.codetaylor.mc.athenaeum.network.tile.client.TileDataServiceClientMonitor;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.TileDataContainerBase;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileDataTracker {
    private final TileDataContainerBase tile;
    private final PacketBuffer packetBuffer;
    private ArrayList<ITileData> data;
    private List<ITileData> toUpdate;

    TileDataTracker(TileDataContainerBase tile) {
        this.tile = tile;
        this.packetBuffer = new PacketBuffer(Unpooled.buffer());
        this.data = new ArrayList(1);
        this.toUpdate = new ArrayList<ITileData>(1);
    }

    void addTileData(ITileData[] toAdd) {
        this.data.addAll(Arrays.asList(toAdd));
        this.data.trimToSize();
        this.toUpdate = new ArrayList<ITileData>(this.data.size());
    }

    public TileDataContainerBase getTile() {
        return this.tile;
    }

    PacketBuffer getUpdateBuffer() {
        int i;
        int dirtyCount = 0;
        for (i = 0; i < this.data.size(); ++i) {
            this.data.get(i).update();
            if (!this.data.get(i).isDirty()) continue;
            ++dirtyCount;
        }
        this.packetBuffer.clear();
        if (dirtyCount > 0) {
            this.packetBuffer.writeInt(dirtyCount);
            for (i = 0; i < this.data.size(); ++i) {
                if (!this.data.get(i).isDirty()) continue;
                this.packetBuffer.writeInt(i);
                this.data.get(i).write(this.packetBuffer);
                this.data.get(i).setDirty(false);
            }
        }
        return this.packetBuffer;
    }

    @SideOnly(value=Side.CLIENT)
    void updateClient(PacketBuffer buffer) throws IOException {
        int dirtyCount = buffer.readInt();
        if (dirtyCount > 0) {
            int i;
            for (i = 0; i < dirtyCount; ++i) {
                ITileData data = this.data.get(buffer.readInt());
                data.read(buffer);
                data.setDirty(true);
                this.toUpdate.add(data);
                TileDataServiceClientMonitor.onClientTrackerUpdateReceived(this.tile.func_174877_v(), data.getClass());
            }
            this.tile.onTileDataUpdate();
            for (i = this.toUpdate.size() - 1; i >= 0; --i) {
                this.toUpdate.remove(i).setDirty(false);
            }
        }
    }
}

