/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.network;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class ThreadedNetworkWrapper {
    private final SimpleNetworkWrapper parent;

    public ThreadedNetworkWrapper(String channelName) {
        this.parent = new SimpleNetworkWrapper(channelName);
    }

    public <Q extends IMessage, A extends IMessage> void registerMessage(Class<? extends IMessageHandler<Q, A>> messageHandler, Class<Q> requestMessageType, int discriminator, Side side) {
        this.registerMessage(this.instantiate(messageHandler), requestMessageType, discriminator, side);
    }

    private <Q extends IMessage, A extends IMessage> IMessageHandler<? super Q, ? extends A> instantiate(Class<? extends IMessageHandler<? super Q, ? extends A>> handler) {
        try {
            return handler.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <Q extends IMessage, A extends IMessage> void registerMessage(IMessageHandler<? super Q, ? extends A> messageHandler, Class<Q> requestMessageType, int discriminator, Side side) {
        this.parent.registerMessage(new Wrapper<Q, A>(messageHandler), requestMessageType, discriminator, side);
    }

    public Packet<?> getPacketFrom(IMessage message) {
        return this.parent.getPacketFrom(message);
    }

    public void sendToAll(IMessage message) {
        this.parent.sendToAll(message);
    }

    public void sendTo(IMessage message, EntityPlayerMP player) {
        this.parent.sendTo(message, player);
    }

    public void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        this.parent.sendToAllAround(message, point);
    }

    public void sendToDimension(IMessage message, int dimensionId) {
        this.parent.sendToDimension(message, dimensionId);
    }

    public void sendToServer(IMessage message) {
        this.parent.sendToServer(message);
    }

    private final class Wrapper<Q extends IMessage, A extends IMessage>
    implements IMessageHandler<Q, A> {
        private final IMessageHandler<Q, A> wrapped;

        public Wrapper(IMessageHandler<Q, A> wrapped) {
            this.wrapped = wrapped;
        }

        public A onMessage(Q message, MessageContext ctx) {
            Minecraft target;
            Object object = target = ctx.side == Side.CLIENT ? Minecraft.func_71410_x() : FMLCommonHandler.instance().getMinecraftServerInstance();
            if (target != null) {
                target.func_152344_a((Runnable)new Runner(this, message, ctx));
            }
            return null;
        }

        public String toString() {
            return this.wrapped.toString();
        }

        public int hashCode() {
            return this.wrapped.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Wrapper) {
                return this.wrapped.equals(((Wrapper)obj).wrapped);
            }
            return this.wrapped.equals(obj);
        }

        private static final class Runner
        implements Runnable {
            private final Q message;
            private final MessageContext ctx;
            final /* synthetic */ Wrapper this$1;

            public Runner(Q message, MessageContext ctx) {
                this.this$1 = var1_1;
                this.message = message;
                this.ctx = ctx;
            }

            @Override
            public void run() {
                IMessage reply = this.this$1.wrapped.onMessage(this.message, this.ctx);
                if (reply != null) {
                    if (this.ctx.side == Side.CLIENT) {
                        this.this$1.ThreadedNetworkWrapper.this.sendToServer(reply);
                    } else {
                        EntityPlayerMP player = this.ctx.getServerHandler().field_147369_b;
                        if (player != null) {
                            this.this$1.ThreadedNetworkWrapper.this.sendTo(reply, player);
                        }
                    }
                }
            }
        }
    }
}

