/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.integration.crafttweaker.mtlib.helpers;

import com.codetaylor.mc.athenaeum.integration.crafttweaker.mtlib.helpers.CTInputHelper;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class CTStackHelper {
    public static boolean areEqual(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_190926_b() || stack2.func_190926_b()) {
            return false;
        }
        return stack1.func_77969_a(stack2);
    }

    public static boolean areEqual(FluidStack stack1, FluidStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        return stack1.isFluidEqual(stack2);
    }

    public static boolean areEqualOrNull(ItemStack stack1, ItemStack stack2) {
        if (stack1 == stack2) {
            return true;
        }
        return CTStackHelper.areEqual(stack1, stack2);
    }

    public static boolean areEqualOrNull(FluidStack stack1, FluidStack stack2) {
        if (stack1 == stack2) {
            return true;
        }
        return CTStackHelper.areEqual(stack1, stack2);
    }

    public static boolean matches(IIngredient ingredient, IItemStack itemStack) {
        if (ingredient == null) {
            return false;
        }
        return ingredient.matches(itemStack);
    }

    public static boolean matches(IIngredient ingredient, IItemStack[] itemStack) {
        if (ingredient == null) {
            return false;
        }
        for (IItemStack stack : itemStack) {
            if (ingredient.matches(stack)) continue;
            return false;
        }
        return true;
    }

    public static boolean matches(IIngredient ingredient, ILiquidStack liquidStack) {
        if (ingredient == null) {
            return false;
        }
        if (ingredient.matches(liquidStack)) {
            return true;
        }
        if (ingredient.getLiquids() != null) {
            for (ILiquidStack liquid : ingredient.getLiquids()) {
                if (!CTInputHelper.toFluid(liquid).isFluidEqual(CTInputHelper.toFluid(liquidStack))) continue;
                return true;
            }
        }
        return false;
    }
}

