/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.integration.crafttweaker;

import com.codetaylor.mc.athenaeum.integration.crafttweaker.PluginModDelegate;
import crafttweaker.IAction;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class PluginDelegate {
    private static final Map<String, PluginModDelegate> DELEGATE_MAP = new HashMap<String, PluginModDelegate>();

    static void registerZenClass(Class<?> zenClass) {
        PluginDelegate.getPluginModDelegate(PluginDelegate.getModId()).registerZenClass(zenClass);
    }

    public static void addAddition(String modId, IAction action) {
        PluginDelegate.getPluginModDelegate(modId).addAddition(action);
    }

    public static void addRemoval(String modId, IAction action) {
        PluginDelegate.getPluginModDelegate(modId).addRemoval(action);
    }

    static void init() {
        PluginModDelegate delegate = DELEGATE_MAP.get(PluginDelegate.getModId());
        if (delegate != null) {
            delegate.init();
        }
    }

    static void apply() {
        PluginModDelegate delegate = DELEGATE_MAP.get(PluginDelegate.getModId());
        if (delegate != null) {
            delegate.apply();
        }
    }

    private static PluginModDelegate getPluginModDelegate(String modId) {
        return DELEGATE_MAP.computeIfAbsent(modId, s -> new PluginModDelegate());
    }

    private static String getModId() {
        ModContainer modContainer = Loader.instance().activeModContainer();
        if (modContainer == null) {
            throw new RuntimeException("Active mod container is null");
        }
        return modContainer.getModId();
    }
}

