/*
 * Decompiled with CFR 0.152.
 */
package com.Fishmod.mod_LavaCow.entities.tameable;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityFishTameable
extends EntityTameable {
    protected static final DataParameter<Float> DATA_HEALTH = EntityDataManager.func_187226_a(EntityFishTameable.class, (DataSerializer)DataSerializers.field_187193_c);
    protected State state;
    private EntityAIWanderAvoidWater wander;
    private EntityAIFollowOwner follow;

    public EntityFishTameable(World worldIn) {
        super(worldIn);
        this.func_70903_f(false);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DATA_HEALTH, (Object)Float.valueOf(this.func_110143_aJ()));
        this.state = State.WANDERING;
    }

    protected void func_184651_r() {
        this.wander = new EntityAIWanderAvoidWater((EntityCreature)this, 1.0, 0.0f);
        this.follow = new EntityAIFollowOwner((EntityTameable)this, 1.0, 10.0f, 2.0f);
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)this.wander);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
    }

    protected boolean isValidLightLevel() {
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (this.field_70170_p.func_175642_b(EnumSkyBlock.SKY, blockpos) > this.field_70146_Z.nextInt(32)) {
            return false;
        }
        int i = this.field_70170_p.func_175671_l(blockpos);
        if (this.field_70170_p.func_72911_I()) {
            int j = this.field_70170_p.func_175657_ab();
            this.field_70170_p.func_175692_b(10);
            i = this.field_70170_p.func_175671_l(blockpos);
            this.field_70170_p.func_175692_b(j);
        }
        return i <= this.field_70146_Z.nextInt(8);
    }

    public float func_180484_a(BlockPos pos) {
        return 10.0f - this.field_70170_p.func_175724_o(pos);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_70601_bi() {
        IBlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177977_b());
        if (!this.isValidLightLevel()) return false;
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) return false;
        BlockPos blockPos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (!(this.func_180484_a(blockPos) >= 0.0f)) return false;
        if (!iblockstate.func_189884_a((Entity)this)) return false;
        return true;
    }

    protected boolean func_70692_ba() {
        return !this.func_70909_n();
    }

    protected boolean isCommandItem(Item itemIn) {
        return itemIn.equals(Items.field_151055_y);
    }

    protected void doSitCommand(EntityPlayer playerIn) {
        this.field_70714_bg.func_85156_a((EntityAIBase)this.wander);
        this.field_70703_bu = false;
        this.field_70699_by.func_75499_g();
        this.state = State.SITTING;
        playerIn.func_146105_b(new TextComponentTranslation(this.func_70005_c_(), new Object[0]).func_150257_a((ITextComponent)new TextComponentTranslation("command.mod_lavacow.sitting", new Object[0])), true);
    }

    protected void doFollowCommand(EntityPlayer playerIn) {
        this.follow = new EntityAIFollowOwner((EntityTameable)this, 1.0, 10.0f, 2.0f);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.follow);
        this.field_70699_by.func_75499_g();
        this.state = State.FOLLOWING;
        playerIn.func_146105_b(new TextComponentTranslation(this.func_70005_c_(), new Object[0]).func_150257_a((ITextComponent)new TextComponentTranslation("command.mod_lavacow.following", new Object[0])), true);
    }

    protected void doWanderCommand(EntityPlayer playerIn) {
        this.field_70714_bg.func_85156_a((EntityAIBase)this.follow);
        this.wander = new EntityAIWanderAvoidWater((EntityCreature)this, 1.0, 0.0f);
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)this.wander);
        this.field_70699_by.func_75499_g();
        this.state = State.WANDERING;
        playerIn.func_146105_b(new TextComponentTranslation(this.func_70005_c_(), new Object[0]).func_150257_a((ITextComponent)new TextComponentTranslation("command.mod_lavacow.wandering", new Object[0])), true);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (this.func_70613_aW() && this.func_70909_n() && this.func_152114_e((EntityLivingBase)player) && hand.equals((Object)EnumHand.MAIN_HAND) && this.isCommandItem(itemstack.func_77973_b()) && !this.func_184207_aI()) {
            if (this.state.equals((Object)State.WANDERING)) {
                this.doSitCommand(player);
            } else if (this.state.equals((Object)State.SITTING)) {
                this.doFollowCommand(player);
            } else if (this.state.equals((Object)State.FOLLOWING)) {
                this.doWanderCommand(player);
            }
            return true;
        }
        if (this.canTameCondition() && this.func_70877_b(itemstack)) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((EntityAnimal)this, (EntityPlayer)player)) {
                    this.func_193101_c(player);
                    this.field_70699_by.func_75499_g();
                    this.func_70624_b(null);
                    this.func_70606_j(this.func_110138_aP());
                    this.func_70908_e(true);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.func_70908_e(false);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    protected boolean canTameCondition() {
        return !this.func_70909_n();
    }

    public void func_193101_c(EntityPlayer player) {
        this.doFollowCommand(player);
        super.func_193101_c(player);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && !this.func_70909_n() && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.field_70180_af.func_187227_b(DATA_HEALTH, (Object)Float.valueOf(this.func_110143_aJ()));
    }

    public boolean func_70652_k(Entity entityIn) {
        return entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b()));
    }

    public EntityLivingBase getEntityByUniqueId(UUID uniqueId) {
        for (Entity E : this.field_70170_p.field_72996_f) {
            if (!(E instanceof EntityLivingBase) || !E.func_110124_au().equals(uniqueId)) continue;
            return (EntityLivingBase)E;
        }
        return null;
    }

    @Nullable
    public EntityLivingBase func_70902_q() {
        try {
            UUID uuid = this.func_184753_b();
            return uuid == null ? null : this.getEntityByUniqueId(uuid);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.state.equals((Object)State.WANDERING)) {
            compound.func_74774_a("state", (byte)0);
        } else if (this.state.equals((Object)State.SITTING)) {
            compound.func_74774_a("state", (byte)1);
        } else if (this.state.equals((Object)State.FOLLOWING)) {
            compound.func_74774_a("state", (byte)2);
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        switch (compound.func_74771_c("state")) {
            case 0: {
                this.state = State.WANDERING;
                this.field_70699_by.func_75499_g();
                break;
            }
            case 1: {
                this.state = State.SITTING;
                this.field_70714_bg.func_85156_a((EntityAIBase)this.wander);
                this.field_70703_bu = false;
                this.field_70699_by.func_75499_g();
                break;
            }
            case 2: {
                this.state = State.FOLLOWING;
                this.field_70699_by.func_75499_g();
                this.field_70714_bg.func_85156_a((EntityAIBase)this.wander);
                this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.follow);
                break;
            }
        }
    }

    public boolean isPreventingPlayerRest(EntityPlayer playerIn) {
        return !this.func_70909_n();
    }

    static enum State {
        SITTING,
        WANDERING,
        FOLLOWING;

    }
}

