/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.dimstack.worldgen;

import cd4017be.api.recipes.RecipeAPI;
import cd4017be.api.recipes.RecipeScriptContext;
import cd4017be.dimstack.api.API;
import cd4017be.dimstack.api.DisabledBlockGen;
import cd4017be.dimstack.api.IDimension;
import cd4017be.dimstack.api.SharedNoiseFields;
import cd4017be.dimstack.api.TerrainGeneration;
import cd4017be.dimstack.api.TransitionInfo;
import cd4017be.dimstack.api.gen.ITerrainGenerator;
import cd4017be.dimstack.api.util.BlockPredicate;
import cd4017be.dimstack.api.util.NoiseField;
import cd4017be.dimstack.core.Dimensionstack;
import cd4017be.dimstack.core.PortalConfiguration;
import cd4017be.dimstack.util.DebugInfo;
import cd4017be.dimstack.worldgen.CaveGen;
import cd4017be.dimstack.worldgen.NetherTop;
import cd4017be.dimstack.worldgen.NoiseLayerGen;
import cd4017be.dimstack.worldgen.SimpleLayerGen;
import cd4017be.dimstack.worldgen.TransitionGen;
import cd4017be.lib.script.Parameters;
import cd4017be.lib.script.obj.Array;
import cd4017be.lib.script.obj.Error;
import cd4017be.lib.script.obj.IOperand;
import cd4017be.lib.script.obj.Nil;
import cd4017be.lib.script.obj.Number;
import cd4017be.lib.script.obj.Text;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.ChunkGeneratorEvent;
import net.minecraftforge.event.terraingen.InitNoiseGensEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class TerrainGenHandler
implements RecipeAPI.IRecipeHandler {
    private static final String NOISE_FIELD = "noiseField";

    public TerrainGenHandler() {
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        RecipeAPI.Handlers.put(NOISE_FIELD, this);
        RecipeAPI.Handlers.put("basicLayer", this);
        RecipeAPI.Handlers.put("noiseLayer", this);
        RecipeAPI.Handlers.put("nether", this);
        RecipeAPI.Handlers.put("caves", this);
        TerrainGeneration.REGISTRY.put("basicLayer", SimpleLayerGen::new);
        TerrainGeneration.REGISTRY.put("noiseLayer", NoiseLayerGen::new);
        TerrainGeneration.REGISTRY.put("nether", NetherTop::new);
        TerrainGeneration.REGISTRY.put("caves", nbt -> new CaveGen().readNBT((NBTTagCompound)nbt));
    }

    @SubscribeEvent
    public void init(InitNoiseGensEvent<InitNoiseGensEvent.Context> event) {
        TerrainGeneration cfg;
        TransitionInfo ti;
        World world = event.getWorld();
        PortalConfiguration pc = PortalConfiguration.get(world);
        SharedNoiseFields snf = Dimensionstack.INSTANCE.getSettings(SharedNoiseFields.class, false);
        if (snf != null) {
            snf.init(world.func_72905_C());
        }
        if ((ti = pc.getSettings(TransitionInfo.class, false)) != null && ti.init()) {
            this.initTransitions(ti, pc);
        }
        if ((cfg = pc.getSettings(TerrainGeneration.class, false)) != null) {
            cfg.setupNoiseGens(pc, event.getNewValues(), event.getRandom());
        }
        pc.getSettings(DebugInfo.class, true).setInitialized();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void generate(ChunkGeneratorEvent.ReplaceBiomeBlocks event) {
        DisabledBlockGen dbg;
        PortalConfiguration pc = PortalConfiguration.get(event.getWorld());
        pc.getSettings(DebugInfo.class, true).fixInitialization(pc, event.getWorld(), event.getGen());
        TerrainGeneration tg = pc.getSettings(TerrainGeneration.class, false);
        if (tg != null) {
            tg.generate(event.getWorld(), event.getGenerator(), event.getPrimer(), event.getX(), event.getZ());
        }
        if ((dbg = pc.getSettings(DisabledBlockGen.class, false)) != null) {
            BlockPredicate.disableBlock(event.getPrimer(), dbg.disabledBlock);
        }
        pc.getSettings(DebugInfo.class, true).setGenerated();
    }

    private void initTransitions(TransitionInfo cfg, IDimension d) {
        IBlockState block;
        boolean flip;
        TransitionInfo cfg1;
        IDimension d1;
        int n = cfg.sizeTop;
        if (n >= 0 && (d1 = d.nextCeil()) != null && (cfg1 = d1.getSettings(TransitionInfo.class, false)) != null) {
            flip = d.upsideDown() ^ d1.upsideDown();
            IBlockState iBlockState = block = flip ? cfg1.blockTop : cfg1.blockBot;
            if (block != null && block != cfg.blockTop) {
                int c = d.ceilHeight();
                d.getSettings(TerrainGeneration.class, (boolean)true).entries.add(0, new TransitionGen(block, c - n, c + 1, n + (flip ? cfg1.sizeTop : cfg1.sizeBot), true));
            }
        }
        if ((n = cfg.sizeBot) >= 0 && (d1 = d.nextFloor()) != null && (cfg1 = d1.getSettings(TransitionInfo.class, false)) != null) {
            flip = d.upsideDown() ^ d1.upsideDown();
            IBlockState iBlockState = block = flip ? cfg1.blockBot : cfg1.blockTop;
            if (block != null && block != cfg.blockBot) {
                d.getSettings(TerrainGeneration.class, (boolean)true).entries.add(0, new TransitionGen(block, 0, n + 1, n + (flip ? cfg1.sizeBot : cfg1.sizeTop), false));
            }
        }
    }

    public void initConfig(RecipeScriptContext.ConfigConstants cfg) {
        double[] v = (double[])cfg.get("custom_noise_octaves", double[].class, (Object)new double[0]);
        SharedNoiseFields snf = Dimensionstack.INSTANCE.getSettings(SharedNoiseFields.class, true);
        if (v.length > 0) {
            int l = v.length;
            byte[] oct = new byte[l];
            for (int i = 0; i < l; ++i) {
                oct[i] = (byte)v[i];
            }
            snf.octaves = oct;
        } else {
            snf.octaves = new byte[]{4};
        }
        snf.noiseFields = new NoiseField[]{new NoiseField(4, 4, 1.0, 1.0)};
        snf.source = new byte[]{0};
        cfg.get("rem_block_gen", BlockRemInfo.class, (Object)new BlockRemInfo());
        cfg.get("dim_transitions", TransInfo.class, (Object)new TransInfo());
    }

    public void addRecipe(Parameters param) {
        ITerrainGenerator gen;
        String key = param.getString(0);
        if (key.equals(NOISE_FIELD)) {
            NoiseField nf;
            int id;
            String name = param.getString(1);
            NoiseFieldInfo nfi = NoiseFieldInfo.REGISTRY.get(name);
            SharedNoiseFields snf = API.INSTANCE.getSettings(SharedNoiseFields.class, true);
            int src = param.getIndex(2);
            if (nfi == null) {
                id = snf.source.length;
                nfi = new NoiseFieldInfo(name, id).setSource(src);
                snf.source = Arrays.copyOf(snf.source, id + 1);
                snf.noiseFields = Arrays.copyOf(snf.noiseFields, id + 1);
            } else {
                id = nfi.setSource((int)src).id;
            }
            snf.source[id] = (byte)src;
            snf.noiseFields[id] = nf = new NoiseField(param.getIndex(3), param.getIndex(4), param.getNumber(5), param.getNumber(6));
            return;
        }
        if (key.equals("basicLayer")) {
            int y1;
            int y0;
            double[] vec = param.getVectorOrAll(3);
            int l = vec.length;
            int eb = 0;
            int et = 0;
            if (l == 2) {
                y0 = (int)vec[0];
                y1 = (int)vec[1];
            } else if (l == 4) {
                y0 = (int)vec[1];
                y1 = (int)vec[2];
                eb = y0 - (int)vec[0];
                et = (int)vec[3] - y1;
                if (eb < 0) {
                    eb = 0;
                }
                if (et < 0) {
                    et = 0;
                }
            } else {
                throw new IllegalArgumentException("expected 2 or 4 height values @ 3");
            }
            gen = new SimpleLayerGen(BlockPredicate.parse((String)param.get(2, String.class)), y0, y1, eb, et);
        } else if (key.equals("noiseLayer")) {
            Object[] layers = param.getArray(2);
            ArrayList<IBlockState> blocks = new ArrayList<IBlockState>();
            FloatArrayList levels = new FloatArrayList();
            boolean lastB = false;
            for (Object o : layers) {
                if (o instanceof String) {
                    if (lastB) {
                        throw new IllegalArgumentException("Blocks must have discriminator values in between!");
                    }
                    lastB = true;
                    blocks.add(BlockPredicate.parse((String)o));
                    continue;
                }
                if (!(o instanceof Double)) continue;
                if (!lastB) {
                    blocks.add(null);
                }
                lastB = false;
                levels.add(((Double)o).floatValue());
            }
            if (!lastB) {
                blocks.add(null);
            }
            NoiseFieldInfo cfg = NoiseFieldInfo.REGISTRY.getOrDefault(param.getString(4), NoiseFieldInfo.DEFAULT);
            double gradient = param.getNumber(3) / (double)((1 << cfg.octaves) - 1);
            double[] vec = param.getVectorOrAll(5);
            int idx = cfg.id;
            gen = new NoiseLayerGen(blocks.toArray(new IBlockState[blocks.size()]), levels.toFloatArray(), (float)gradient, (int)vec[0], (int)vec[1], idx);
        } else if (key.equals("nether")) {
            Object[] mats = param.getArray(2);
            int n = mats.length;
            IBlockState[] blocks = new IBlockState[n];
            for (int i = 0; i < n; ++i) {
                blocks[i] = BlockPredicate.parse((String)mats[i]);
            }
            double[] vec = param.getVector(3);
            boolean hasLake = vec[1] > 0.0;
            boolean hasSand = vec[2] > 0.0;
            gen = new NetherTop((int)vec[0], (int)vec[3], param.getIndex(4), hasLake ? (int)vec[1] : 0, hasSand ? (int)vec[2] : 0, blocks[0], hasLake || hasSand ? blocks[1] : null, hasSand ? blocks[2] : null, hasSand ? blocks[3] : null, hasSand ? blocks[4] : null, hasSand ? blocks[5] : null);
        } else if (key.equals("caves")) {
            CaveGen cg = new CaveGen();
            cg.replace = BlockPredicate.parse(param.get(2));
            cg.setBlock = BlockPredicate.parse(param.getString(3));
            if (param.get(4) == null) {
                cg.setFluid = cg.setBlock;
                cg.fillY = 0;
            } else {
                cg.setFluid = BlockPredicate.parse(param.getString(4));
            }
            double[] vec = param.getVector(5);
            int l = vec.length;
            if (l < 4) {
                throw new IllegalArgumentException("expected min 4 values @ 5");
            }
            cg.count = (int)vec[0];
            cg.genChance = MathHelper.func_76125_a((int)((int)(vec[1] * 256.0)), (int)1, (int)256);
            cg.minY = MathHelper.func_76125_a((int)((int)vec[2]), (int)0, (int)255);
            cg.maxY = MathHelper.func_76125_a((int)((int)vec[3]), (int)1, (int)256);
            if (l > 2) {
                cg.fillY = MathHelper.func_76125_a((int)((int)vec[2]), (int)0, (int)255);
            }
            if (param.has(6)) {
                vec = param.getVectorOrAll(6);
                l = vec.length;
                if (l < 3) {
                    throw new IllegalArgumentException("expected min 3 values @ 6");
                }
                cg.thickness = (float)vec[0];
                cg.vertShape = (float)vec[1];
                cg.roomSize = (float)vec[2];
                if (l == 5) {
                    cg.bigChance = MathHelper.func_76125_a((int)((int)(vec[3] * 256.0)), (int)1, (int)256);
                    cg.bigScale = (float)vec[4] - 1.0f;
                } else {
                    cg.bigScale = 0.0f;
                }
            }
            gen = cg;
        } else {
            return;
        }
        TerrainGeneration cfg = PortalConfiguration.get(param.getIndex(1)).getSettings(TerrainGeneration.class, true);
        cfg.entries.add(gen);
    }

    private static class TransInfo
    implements IOperand {
        private TransInfo() {
        }

        public boolean asBool() throws Error {
            return true;
        }

        public Object value() {
            return this;
        }

        public IOperand get(IOperand idx) {
            TransitionInfo cfg = PortalConfiguration.get(idx.asIndex()).getSettings(TransitionInfo.class, false);
            return cfg == null ? Nil.NIL : new Array(new IOperand[]{cfg.blockBot == null ? Nil.NIL : new Text(BlockPredicate.serialize(cfg.blockBot)), new Number((double)cfg.sizeBot), cfg.blockTop == null ? Nil.NIL : new Text(BlockPredicate.serialize(cfg.blockTop)), new Number((double)cfg.sizeTop)});
        }

        public void put(IOperand idx, IOperand val) {
            if (!(val instanceof Array)) {
                return;
            }
            IOperand[] arr = ((Array)val).array;
            if (arr.length != 4) {
                return;
            }
            TransitionInfo cfg = PortalConfiguration.get(idx.asIndex()).getSettings(TransitionInfo.class, true);
            cfg.blockBot = arr[0] instanceof Text ? BlockPredicate.parse(((Text)arr[0]).value) : null;
            cfg.blockTop = arr[2] instanceof Text ? BlockPredicate.parse(((Text)arr[2]).value) : null;
            cfg.sizeBot = arr[1].asIndex();
            cfg.sizeTop = arr[3].asIndex();
        }
    }

    private static class BlockRemInfo
    implements IOperand {
        private BlockRemInfo() {
        }

        public boolean asBool() throws Error {
            return true;
        }

        public Object value() {
            return this;
        }

        public IOperand get(IOperand idx) {
            DisabledBlockGen cfg = PortalConfiguration.get(idx.asIndex()).getSettings(DisabledBlockGen.class, false);
            return cfg == null || cfg.disabledBlock == null ? Nil.NIL : new Text(BlockPredicate.serialize(cfg.disabledBlock));
        }

        public void put(IOperand idx, IOperand val) {
            boolean set = val instanceof Text;
            DisabledBlockGen cfg = PortalConfiguration.get(idx.asIndex()).getSettings(DisabledBlockGen.class, set);
            if (set) {
                cfg.disabledBlock = BlockPredicate.parse(((Text)val).value);
            } else if (cfg != null) {
                cfg.disabledBlock = null;
            }
        }
    }

    static class NoiseFieldInfo {
        static HashMap<String, NoiseFieldInfo> REGISTRY = new HashMap();
        static final NoiseFieldInfo DEFAULT = new NoiseFieldInfo("main", 0).setSource(0);
        final int id;
        int octaves;

        NoiseFieldInfo(String name, int id) {
            this.id = id;
            if (REGISTRY.put(name, this) != null) {
                throw new IllegalStateException("noise field '" + name + "' already registered");
            }
        }

        NoiseFieldInfo setSource(int src) {
            switch (src) {
                case -5: 
                case -4: 
                case -1: {
                    this.octaves = 16;
                    break;
                }
                case -2: {
                    this.octaves = 10;
                    break;
                }
                case -6: 
                case -3: {
                    this.octaves = 8;
                    break;
                }
                case -9: 
                case -8: 
                case -7: {
                    this.octaves = 4;
                    break;
                }
                default: {
                    SharedNoiseFields snf = API.INSTANCE.getSettings(SharedNoiseFields.class, false);
                    if (snf != null && src >= 0 && src < snf.octaves.length) {
                        this.octaves = snf.octaves[src];
                        break;
                    }
                    throw new IllegalArgumentException("invalid noise gen source " + src);
                }
            }
            return this;
        }
    }
}

