/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.dimstack.worldgen;

import cd4017be.dimstack.api.gen.IOreGenerator;
import cd4017be.dimstack.api.util.BlockPredicate;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class OreGenBase
implements IOreGenerator {
    private final float veins;
    protected final int size;
    protected final IBlockState ore;
    protected final BlockPredicate target;

    protected OreGenBase(NBTTagCompound tag) {
        this.veins = tag.func_74760_g("vpc");
        this.size = tag.func_74765_d("bpv");
        this.target = BlockPredicate.loadNBT(tag.func_150295_c("target", 8));
        this.ore = BlockPredicate.parse(tag.func_74779_i("ore"));
    }

    protected OreGenBase(IBlockState ore, int size, float veins, BlockPredicate target) {
        this.size = size;
        this.ore = ore;
        this.target = target;
        this.veins = veins;
    }

    @Override
    public NBTTagCompound writeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74776_a("vpc", this.veins);
        nbt.func_74777_a("bpv", (short)this.size);
        nbt.func_74782_a("target", (NBTBase)this.target.writeNBT());
        nbt.func_74778_a("ore", BlockPredicate.serialize(this.ore));
        return nbt;
    }

    protected int veins(Random rand) {
        return MathHelper.func_76141_d((float)(this.veins + rand.nextFloat()));
    }

    protected void genOreVein(World world, int x, int y, int z, Random rand) {
        float f = rand.nextFloat() * (float)Math.PI;
        float sin = MathHelper.func_76126_a((float)f);
        float cos = MathHelper.func_76134_b((float)f);
        double x0 = (float)(x + 8) + sin * (float)this.size / 8.0f;
        double x1 = (float)(x + 8) - sin * (float)this.size / 8.0f;
        double z0 = (float)(z + 8) + cos * (float)this.size / 8.0f;
        double z1 = (float)(z + 8) - cos * (float)this.size / 8.0f;
        double y0 = y + rand.nextInt(3) - 2;
        double y1 = y + rand.nextInt(3) - 2;
        for (int i = 0; i < this.size; ++i) {
            float f1 = (float)i / (float)this.size;
            double x2 = x0 + (x1 - x0) * (double)f1;
            double y2 = y0 + (y1 - y0) * (double)f1;
            double z2 = z0 + (z1 - z0) * (double)f1;
            double d9 = rand.nextDouble() * (double)this.size / 16.0;
            double d10 = (double)(MathHelper.func_76126_a((float)((float)Math.PI * f1)) + 1.0f) * d9 + 1.0;
            double d11 = (double)(MathHelper.func_76126_a((float)((float)Math.PI * f1)) + 1.0f) * d9 + 1.0;
            int j = MathHelper.func_76128_c((double)(x2 - d10 / 2.0));
            int k = MathHelper.func_76128_c((double)(y2 - d11 / 2.0));
            int l = MathHelper.func_76128_c((double)(z2 - d10 / 2.0));
            int i1 = MathHelper.func_76128_c((double)(x2 + d10 / 2.0));
            int j1 = MathHelper.func_76128_c((double)(y2 + d11 / 2.0));
            int k1 = MathHelper.func_76128_c((double)(z2 + d10 / 2.0));
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (int bx = j; bx <= i1; ++bx) {
                double d12 = ((double)bx + 0.5 - x2) / (d10 / 2.0);
                if (!(d12 * d12 < 1.0)) continue;
                for (int by = k; by <= j1; ++by) {
                    double d13 = ((double)by + 0.5 - y2) / (d11 / 2.0);
                    if (!(d12 * d12 + d13 * d13 < 1.0)) continue;
                    for (int bz = l; bz <= k1; ++bz) {
                        double d14 = ((double)bz + 0.5 - z2) / (d10 / 2.0);
                        if (!(d12 * d12 + d13 * d13 + d14 * d14 < 1.0)) continue;
                        pos.func_181079_c(bx, by, bz);
                        IBlockState state = world.func_180495_p((BlockPos)pos);
                        if (!state.func_177230_c().isReplaceableOreGen(state, (IBlockAccess)world, (BlockPos)pos, this.target::test)) continue;
                        world.func_180501_a((BlockPos)pos, this.ore, 2);
                    }
                }
            }
        }
    }
}

