/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.dimstack.core;

import cd4017be.dimstack.Main;
import cd4017be.dimstack.Objects;
import cd4017be.dimstack.api.CustomWorldProps;
import cd4017be.dimstack.core.ChunkGeneratorVoid;
import cd4017be.dimstack.core.PortalConfiguration;
import net.minecraft.init.Biomes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProviderSingle;
import net.minecraft.world.gen.ChunkGeneratorHell;
import net.minecraft.world.gen.ChunkGeneratorOverworld;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldProviderCustom
extends WorldProvider {
    PortalConfiguration stack;
    CustomWorldProps cfg;

    public void setDimension(int dim) {
        super.setDimension(dim);
        this.stack = PortalConfiguration.get(dim);
    }

    public DimensionType func_186058_p() {
        return Objects.CUSTOM_DIM_TYPE;
    }

    protected void func_76572_b() {
        this.cfg = this.stack.getSettings(CustomWorldProps.class, true);
        this.field_191067_f = (this.cfg.flags & 1) != 0;
        this.field_76575_d = (this.cfg.flags & 2) != 0;
        boolean bl = this.field_76576_e = (this.cfg.flags & 4) != 0;
        if (this.cfg.biomeGen.isEmpty()) {
            this.field_76578_c = this.field_76579_a.func_175624_G().getBiomeProvider(this.field_76579_a);
        } else {
            Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(this.cfg.biomeGen));
            if (biome == null) {
                Main.LOG.error("Invalid biome id {}, falling back to single biome plains instead!", (Object)this.cfg.biomeGen);
                biome = Biomes.field_76772_c;
            }
            this.field_76578_c = new BiomeProviderSingle(biome);
        }
    }

    public IChunkGenerator func_186060_c() {
        CustomWorldProps props = this.stack.getSettings(CustomWorldProps.class, true);
        WorldInfo info = this.field_76579_a.func_72912_H();
        switch (props.chunkGen) {
            default: {
                return new ChunkGeneratorVoid(this.field_76579_a, this.field_76579_a.func_72905_C());
            }
            case 1: {
                return super.func_186060_c();
            }
            case 2: {
                return new ChunkGeneratorOverworld(this.field_76579_a, this.field_76579_a.func_72905_C(), info.func_76089_r(), info.func_82571_y());
            }
            case 3: 
        }
        return new ChunkGeneratorHell(this.field_76579_a, info.func_76089_r(), this.field_76579_a.func_72905_C());
    }

    public int getActualHeight() {
        return this.stack.ceilY;
    }

    public int getHeight() {
        return this.stack.ceilY + 1;
    }

    public boolean func_76569_d() {
        return (this.cfg.flags & 8) != 0;
    }

    public boolean shouldClientCheckLighting() {
        return !this.field_191067_f;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76568_b(int x, int z) {
        return (this.cfg.flags & 0x10) != 0;
    }

    public double func_76565_k() {
        return (double)(this.cfg.fogColor >>> 24) / 256.0;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d func_76562_b(float celAng, float t) {
        float f1 = (float)(this.cfg.fogColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(this.cfg.fogColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(this.cfg.fogColor & 0xFF) / 255.0f;
        if ((this.cfg.flags & 8) != 0) {
            float f = MathHelper.func_76134_b((float)(celAng * ((float)Math.PI * 2))) * 2.0f + 0.5f;
            f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
            f1 *= f * 0.94f + 0.06f;
            f2 *= f * 0.94f + 0.06f;
            f3 *= f * 0.91f + 0.09f;
        }
        return new Vec3d((double)f1, (double)f2, (double)f3);
    }

    @SideOnly(value=Side.CLIENT)
    public float func_76571_f() {
        return this.cfg.cloudHeight;
    }

    public double getHorizon() {
        return this.cfg.horizonHeight;
    }
}

