/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.dimstack.core;

import cd4017be.dimstack.Main;
import cd4017be.dimstack.core.ChunkLoader;
import cd4017be.dimstack.core.PortalConfiguration;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.common.ForgeChunkManager;

public class LoadingInfo {
    public final PortalConfiguration pc;
    public final long startTime;
    public final ChunkPos chunk;
    public long lastReqT;
    public long lastReqB;

    public LoadingInfo(PortalConfiguration pc, BlockPos from) {
        long t;
        this.pc = pc;
        this.startTime = t = System.currentTimeMillis();
        this.chunk = new ChunkPos(from);
        if (from.func_177956_o() == 0) {
            this.lastReqT = t;
            this.lastReqB = Long.MIN_VALUE;
        } else {
            this.lastReqT = Long.MIN_VALUE;
            this.lastReqB = t;
        }
        ForgeChunkManager.Ticket ticket = pc.loadingTicket;
        int n = ticket.getChunkListDepth();
        if (pc.loadedChunks.size() >= n) {
            pc.unforceLeastRelevantChunks(n - 1);
        }
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)this.chunk);
        Main.LOG.debug("forced chunk {} in {}", (Object)this.chunk, (Object)pc.dimId);
    }

    public void onRequest(BlockPos from) {
        long t = System.currentTimeMillis();
        if (from.func_177956_o() == 0) {
            this.lastReqT = t;
        } else {
            this.lastReqB = t;
        }
    }

    public LoadingInfo onUnload(boolean top) {
        if (top) {
            this.lastReqT = Long.MIN_VALUE;
        } else {
            this.lastReqB = Long.MIN_VALUE;
        }
        Main.LOG.debug("{} access of chunk {} in {} became unloaded", (Object)(top ? "TOP" : "BOTTOM"), (Object)this.chunk, (Object)this.pc.dimId);
        return this;
    }

    public boolean checkExpired(long t) {
        if (this.lastReqB < t && this.lastReqT < t) {
            Main.LOG.debug("unforced chunk {} in {} after {}", (Object)this.chunk, (Object)this.pc.dimId, (Object)String.format("%.2fs", Float.valueOf((float)(t - this.startTime + ChunkLoader.EXPIRE_TIME) / 1000.0f)));
            return true;
        }
        return false;
    }

    public float stillNeeded(long t) {
        long s = this.startTime;
        float ref = t - s + ChunkLoader.EXPIRE_TIME;
        float f = 0.0f;
        long rt = this.lastReqB;
        if (rt >= s) {
            f += ref / (float)(t - rt) - 1.0f;
        }
        if ((rt = this.lastReqT) >= s) {
            f += ref / (float)(t - rt) - 1.0f;
        }
        return Math.max(1.0f - 1.0f / f, 0.0f);
    }

    public void remove() {
        this.pc.loadedChunks.remove(this.chunk);
        if (this.pc.loadingTicket == null) {
            return;
        }
        ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.pc.loadingTicket, (ChunkPos)this.chunk);
        if (this.pc.loadedChunks.isEmpty()) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.pc.loadingTicket);
            this.pc.loadingTicket = null;
        }
    }
}

