/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.dimstack.core;

import cd4017be.api.recipes.RecipeScriptContext;
import cd4017be.dimstack.Main;
import cd4017be.dimstack.core.LoadingInfo;
import cd4017be.dimstack.core.PortalConfiguration;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ChunkLoader
implements ForgeChunkManager.OrderedLoadingCallback {
    private static ChunkLoader instance;
    public static long EXPIRE_TIME;
    public static long OVER_TIME;
    public static int CHECK_INTERVAL;
    private int timer;

    public static void initConfig(RecipeScriptContext.ConfigConstants cfg) {
        EXPIRE_TIME = (long)(cfg.getNumber("chunk_load_time", (double)EXPIRE_TIME / 1000.0) * 1000.0);
        OVER_TIME = (long)(cfg.getNumber("cont_load_time", (double)OVER_TIME / 1000.0) * 1000.0);
        CHECK_INTERVAL = (int)(EXPIRE_TIME / 200L);
        if (EXPIRE_TIME > 0L && instance == null) {
            instance = new ChunkLoader();
        }
    }

    public static boolean active() {
        return instance != null;
    }

    private ChunkLoader() {
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)Main.instance, (ForgeChunkManager.LoadingCallback)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public List<ForgeChunkManager.Ticket> ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world, int maxTicketCount) {
        return Collections.emptyList();
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        PortalConfiguration pc;
        World world = event.getWorld();
        if (world instanceof WorldServer && ((pc = PortalConfiguration.get(world)).up() != null || pc.down() != null)) {
            world.func_72954_a((IWorldEventListener)pc);
        }
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload event) {
        LoadingInfo ti;
        PortalConfiguration pc = (PortalConfiguration)PortalConfiguration.dimensions.get(event.getWorld().field_73011_w.getDimension());
        if (pc == null || pc.loadingTicket == null) {
            return;
        }
        ChunkPos pos = event.getChunk().func_76632_l();
        PortalConfiguration pc1 = pc.up();
        if (pc1 != null && (ti = pc1.loadedChunks.get(pos)) != null && ti.onUnload(false).checkExpired(System.currentTimeMillis() - EXPIRE_TIME)) {
            ti.remove();
        }
        if ((pc1 = pc.down()) != null && (ti = pc1.loadedChunks.get(pos)) != null && ti.onUnload(true).checkExpired(System.currentTimeMillis() - EXPIRE_TIME)) {
            ti.remove();
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.START || --this.timer > 0) {
            return;
        }
        this.timer = CHECK_INTERVAL;
        long t = System.currentTimeMillis() - EXPIRE_TIME;
        for (PortalConfiguration pc : PortalConfiguration.dimensions.values()) {
            if (pc.loadingTicket == null) continue;
            PortalConfiguration up = pc.up();
            PortalConfiguration down = pc.down();
            Iterator<LoadingInfo> it = pc.loadedChunks.values().iterator();
            while (it.hasNext()) {
                LoadingInfo li = it.next();
                if (t > li.startTime) {
                    if (li.lastReqT > t && up != null && !ChunkLoader.isChunkExternallyForced(up.dimId, li.chunk)) {
                        li.onUnload(true);
                    }
                    if (li.lastReqB > t && down != null && !ChunkLoader.isChunkExternallyForced(down.dimId, li.chunk)) {
                        li.onUnload(false);
                    }
                }
                if (!li.checkExpired(t)) continue;
                it.remove();
                li.remove();
            }
        }
    }

    public static boolean isChunkExternallyForced(int dim, ChunkPos chunk) {
        WorldServer world = DimensionManager.getWorld((int)dim);
        if (world == null || !world.func_175667_e(chunk.func_180331_a(8, 64, 8))) {
            return false;
        }
        for (ForgeChunkManager.Ticket t : ForgeChunkManager.getPersistentChunksFor((World)world).get((Object)chunk)) {
            if ("dimstack".equals(t.getModId())) continue;
            return true;
        }
        return !world.field_73011_w.func_186056_c(chunk.field_77276_a, chunk.field_77275_b) || world.func_184164_w().func_152621_a(chunk.field_77276_a, chunk.field_77275_b);
    }

    static {
        EXPIRE_TIME = 30000L;
        OVER_TIME = 300000L;
        CHECK_INTERVAL = 60;
    }
}

