/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.dimstack.api.util;

import java.util.Arrays;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraftforge.oredict.OreDictionary;

public class BlockPredicate
implements Predicate<IBlockState> {
    static final Random RAND = new Random();
    final Predicate<IBlockState>[] matchers;
    final String[] cfg;

    public BlockPredicate(String ... blocks) {
        int n = blocks.length;
        this.cfg = blocks;
        this.matchers = new Predicate[n];
        for (int i = 0; i < n; ++i) {
            String s = this.cfg[i];
            if (s.startsWith("ore:")) {
                int id = OreDictionary.getOreID((String)s.substring(4));
                this.matchers[i] = state -> {
                    Block block = state.func_177230_c();
                    ItemStack stack = new ItemStack(block.func_180660_a(state, RAND, 0), block.func_180651_a(state));
                    if (!stack.func_190926_b()) {
                        for (int o : OreDictionary.getOreIDs((ItemStack)stack)) {
                            if (o != id) continue;
                            return true;
                        }
                    }
                    return false;
                };
                continue;
            }
            if (s.indexOf(64) >= 0) {
                this.matchers[i] = Predicate.isEqual(BlockPredicate.parse(s));
                continue;
            }
            Block block = Block.func_149684_b((String)s);
            this.matchers[i] = state -> state.func_177230_c() == block;
        }
    }

    public static BlockPredicate loadNBT(NBTTagList list) {
        int n = list.func_74745_c();
        String[] cfg = new String[n];
        for (int i = 0; i < n; ++i) {
            cfg[i] = list.func_150307_f(i);
        }
        return new BlockPredicate(cfg);
    }

    public NBTTagList writeNBT() {
        NBTTagList list = new NBTTagList();
        for (String s : this.cfg) {
            list.func_74742_a((NBTBase)new NBTTagString(s));
        }
        return list;
    }

    @Override
    public boolean test(IBlockState arg0) {
        for (Predicate<IBlockState> p : this.matchers) {
            if (!p.test(arg0)) continue;
            return true;
        }
        return this.matchers.length == 0;
    }

    public String toString() {
        return Arrays.toString(this.cfg);
    }

    public static BlockPredicate parse(Object param) {
        if (param instanceof String) {
            return new BlockPredicate((String)param);
        }
        if (param instanceof Object[]) {
            Object[] arr = (Object[])param;
            return new BlockPredicate((String[])Arrays.copyOf(arr, arr.length, String[].class));
        }
        if (param == null) {
            return new BlockPredicate(new String[0]);
        }
        throw new IllegalArgumentException("expected String or Array of Strings");
    }

    public static IBlockState parse(String s) {
        try {
            if (s.startsWith("ore:")) {
                for (ItemStack stack : OreDictionary.getOres((String)s.substring(4))) {
                    Item item = stack.func_77973_b();
                    if (!(item instanceof ItemBlock)) continue;
                    return ((ItemBlock)item).func_179223_d().func_176203_a(item.func_77647_b(stack.func_77960_j()));
                }
                return Blocks.field_150350_a.func_176223_P();
            }
            int p = s.indexOf(64);
            if (p < 0) {
                return Block.func_149684_b((String)s).func_176223_P();
            }
            Block block = Block.func_149684_b((String)s.substring(0, p));
            return block.func_176203_a(Integer.parseInt(s.substring(p + 1)));
        }
        catch (Exception e) {
            return Blocks.field_150350_a.func_176223_P();
        }
    }

    public static String serialize(IBlockState s) {
        Block b = s.func_177230_c();
        return b.getRegistryName() + "@" + b.func_176201_c(s);
    }

    public static void disableBlock(ChunkPrimer cp, IBlockState state) {
    }
}

