/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.dimstack.api;

import cd4017be.dimstack.api.IDimensionSettings;
import cd4017be.dimstack.api.util.BlockPredicate;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class BlockReplacements
implements IDimensionSettings {
    public final ArrayList<Replacement> replacements = new ArrayList();

    public NBTTagList serializeNBT() {
        if (this.replacements.isEmpty()) {
            return null;
        }
        NBTTagList list = new NBTTagList();
        for (Replacement r : this.replacements) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74777_a("minY", (short)r.minY);
            tag.func_74777_a("maxY", (short)r.maxY);
            tag.func_74782_a("target", (NBTBase)r.target.writeNBT());
            tag.func_74778_a("block", BlockPredicate.serialize(r.repl));
            list.func_74742_a((NBTBase)tag);
        }
        return list;
    }

    public void deserializeNBT(NBTBase nbt) {
        NBTTagList list = (NBTTagList)nbt;
        for (NBTBase tag : list) {
            NBTTagCompound ctag = (NBTTagCompound)tag;
            try {
                Replacement r = new Replacement(BlockPredicate.loadNBT(ctag.func_150295_c("target", 8)), BlockPredicate.parse(ctag.func_74779_i("block")), ctag.func_74765_d("minY"), ctag.func_74765_d("maxY"));
                this.replacements.add(r);
            }
            catch (Exception exception) {}
        }
    }

    public static class Replacement {
        public BlockPredicate target;
        public IBlockState repl;
        public int minY;
        public int maxY;

        public Replacement(BlockPredicate target, IBlockState repl, int minY, int maxY) {
            this.target = target;
            this.repl = repl;
            this.minY = Math.max(0, minY);
            this.maxY = Math.min(256, maxY);
        }

        public void doReplace(World world, int cx, int cz) {
            int z;
            Chunk chunk = world.func_72964_e(cx, cz);
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            BlockPredicate target = this.target;
            IBlockState repl = this.repl;
            int x0 = cx << 4;
            int x1 = x0 + 16;
            int y0 = this.minY;
            int y1 = this.maxY;
            int z1 = z + 16;
            for (z = cz << 4; z < z1; ++z) {
                for (int x = x0; x < x1; ++x) {
                    for (int y = y0; y < y1; ++y) {
                        if (!target.test(chunk.func_177435_g((BlockPos)pos.func_181079_c(x, y, z)))) continue;
                        chunk.func_177436_a((BlockPos)pos, repl);
                    }
                }
            }
        }
    }
}

