/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.controlledburn;

import com.fantasticsource.controlledburn.FireConfig;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class FireData {
    public static int replaceBlockWithFireChanceRange;
    public static LinkedHashMap<IBlockState, IBlockState> blockTransformationMap;

    public static void update() {
        String[] tokens;
        replaceBlockWithFireChanceRange = FireConfig.burnSpreadChances.maxBurnSpreadChance - FireConfig.burnSpreadChances.minBurnSpreadChance;
        for (String string : FireConfig.blockSettings) {
            tokens = string.split(",");
            if (tokens.length != 3) {
                System.err.println("Wrong number of arguments for block-specific setting; please check example in tooltip");
                continue;
            }
            String token = tokens[0].trim();
            ResourceLocation resourceLocation = new ResourceLocation(token);
            if (!ForgeRegistries.BLOCKS.containsKey(resourceLocation)) {
                System.err.println("Block not found: " + token);
                continue;
            }
            Block b = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation);
            if (b == null) {
                System.err.println("Block was found, but was null (this should never happen): " + token);
                continue;
            }
            token = tokens[1].trim();
            int f = token.equals("=") ? Blocks.field_150480_ab.func_176532_c(b) : Integer.parseInt(token);
            token = tokens[2].trim();
            int e = token.equals("=") ? Blocks.field_150480_ab.func_176534_d(b) : Integer.parseInt(token);
            Blocks.field_150480_ab.func_180686_a(b, e, f);
        }
        blockTransformationMap.clear();
        for (String s : FireConfig.blockTransformations) {
            tokens = s.split(",");
            if (tokens.length != 2) {
                System.err.println("Invalid block transformation entry: " + s);
                continue;
            }
            ArrayList<IBlockState> fromStates = FireData.blockstatesMatching(tokens[0]);
            ArrayList<IBlockState> toStates = FireData.blockstatesMatching(tokens[1]);
            if (fromStates == null || toStates == null || fromStates.size() == 0 || toStates.size() == 0) {
                System.err.println("Invalid block transformation entry: " + s);
                continue;
            }
            if (toStates.size() == 1) {
                for (IBlockState state : fromStates) {
                    blockTransformationMap.put(state, toStates.get(0));
                }
                continue;
            }
            if (fromStates.size() == toStates.size()) {
                for (int i = 0; i < fromStates.size(); ++i) {
                    blockTransformationMap.put(fromStates.get(i), toStates.get(i));
                }
                continue;
            }
            for (IBlockState state : fromStates) {
                blockTransformationMap.put(state, toStates.get(0));
            }
        }
    }

    protected static ArrayList<IBlockState> blockstatesMatching(String blockID) {
        String name;
        ArrayList<IBlockState> result = new ArrayList<IBlockState>();
        String[] tokens = blockID.split(":");
        String domain = "minecraft";
        String meta = "*";
        switch (tokens.length) {
            case 1: {
                name = tokens[0].trim();
                break;
            }
            case 2: {
                if (tokens[1].trim().equals("*")) {
                    name = tokens[0].trim();
                    break;
                }
                try {
                    meta = "" + Integer.parseInt(tokens[1].trim());
                    name = tokens[0].trim();
                }
                catch (NumberFormatException e) {
                    domain = tokens[0].trim();
                    name = tokens[1].trim();
                }
                break;
            }
            case 3: {
                domain = tokens[0].trim();
                name = tokens[1].trim();
                meta = tokens[2].trim();
                break;
            }
            default: {
                System.err.println("Invalid blockstate entry: " + tokens[1]);
                return null;
            }
        }
        ResourceLocation rl = new ResourceLocation(domain, name);
        if (!ForgeRegistries.BLOCKS.containsKey(rl)) {
            System.err.println("Block not found: " + rl);
            return null;
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(rl);
        if (block == null) {
            System.err.println("Block was null: " + rl);
            return null;
        }
        try {
            int i = Integer.parseInt(meta);
            try {
                IBlockState state = block.func_176203_a(i);
                result.add(state);
            }
            catch (Exception exception) {}
        }
        catch (NumberFormatException e) {
            for (int i = 0; i < 16; ++i) {
                IBlockState state;
                try {
                    state = block.func_176203_a(i);
                }
                catch (Exception e2) {
                    continue;
                }
                if (result.contains(state)) continue;
                result.add(state);
            }
        }
        return result;
    }

    static {
        blockTransformationMap = new LinkedHashMap();
    }
}

