/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.controlledburn;

import com.fantasticsource.controlledburn.ControlledBurn;
import com.fantasticsource.controlledburn.FireConfig;
import com.fantasticsource.controlledburn.FireData;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFireEdit
extends BlockFire {
    private static boolean tryBurnBlockSpecial(World world, BlockPos pos) {
        IBlockState blockTo = FireData.blockTransformationMap.get(world.func_180495_p(pos));
        if (blockTo != null) {
            world.func_175656_a(pos, blockTo);
            return true;
        }
        return false;
    }

    public int func_149738_a(World worldIn) {
        return FireConfig.globalMultipliers.tickDelay;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        int humidModifier;
        if (!worldIn.func_82736_K().func_82766_b("doFireTick")) {
            return;
        }
        if (!worldIn.func_175697_a(pos, 2)) {
            return;
        }
        if (!this.func_176196_c(worldIn, pos)) {
            worldIn.func_175698_g(pos);
            return;
        }
        boolean fireSourceBelow = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c().isFireSource(worldIn, pos.func_177977_b(), EnumFacing.UP);
        int age = (Integer)state.func_177229_b((IProperty)field_176543_a);
        if (!fireSourceBelow && !FireConfig.specialToggles.ignoreRain && worldIn.func_72896_J() && this.func_176537_d(worldIn, pos) && rand.nextFloat() < 0.2f + (float)age * 0.03f) {
            worldIn.func_175698_g(pos);
            return;
        }
        if (age < ControlledBurn.maxFireAge()) {
            state = state.func_177226_a((IProperty)field_176543_a, (Comparable)Integer.valueOf(rand.nextInt(3) == 2 ? ++age : age));
            worldIn.func_180501_a(pos, state, 4);
        }
        if (!fireSourceBelow) {
            if (!this.canNeighborCatchFire(worldIn, pos)) {
                if (!worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) || age > 3) {
                    worldIn.func_175698_g(pos);
                } else {
                    worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn) + rand.nextInt(10));
                }
                return;
            }
            if (!this.func_176535_e((IBlockAccess)worldIn, pos.func_177977_b()) && age >= ControlledBurn.maxFireAge() && rand.nextInt(4) == 0) {
                worldIn.func_175698_g(pos);
                return;
            }
        }
        boolean feelsHumid = worldIn.func_180502_D(pos) && !FireConfig.specialToggles.ignoreHumidBiomes;
        int n = humidModifier = feelsHumid ? -50 : 0;
        if (FireConfig.globalMultipliers.burnSpeedMultiplier != 0.0) {
            this.tryBurnAdjacent(worldIn, pos.func_177977_b(), 250 + humidModifier, rand, age, EnumFacing.UP);
            this.tryBurnAdjacent(worldIn, pos.func_177984_a(), 250 + humidModifier, rand, age, EnumFacing.DOWN);
            this.tryBurnAdjacent(worldIn, pos.func_177968_d(), 300 + humidModifier, rand, age, EnumFacing.NORTH);
            this.tryBurnAdjacent(worldIn, pos.func_177978_c(), 300 + humidModifier, rand, age, EnumFacing.SOUTH);
            this.tryBurnAdjacent(worldIn, pos.func_177976_e(), 300 + humidModifier, rand, age, EnumFacing.EAST);
            this.tryBurnAdjacent(worldIn, pos.func_177974_f(), 300 + humidModifier, rand, age, EnumFacing.WEST);
        }
        if (FireConfig.globalMultipliers.spreadSpeedMultiplier > 0.0) {
            for (int trySpreadX = -FireConfig.spreadRanges.reachHorizontal; trySpreadX <= FireConfig.spreadRanges.reachHorizontal; ++trySpreadX) {
                for (int trySpreadZ = -FireConfig.spreadRanges.reachHorizontal; trySpreadZ <= FireConfig.spreadRanges.reachHorizontal; ++trySpreadZ) {
                    for (int trySpreadY = -FireConfig.spreadRanges.reachBelow; trySpreadY <= FireConfig.spreadRanges.reachAbove; ++trySpreadY) {
                        int childAge;
                        int spreadDifficulty;
                        BlockPos spreadPos;
                        int adjacentEncouragement;
                        if (trySpreadX == 0 && trySpreadY == 0 && trySpreadZ == 0 || (adjacentEncouragement = this.getNeighborEncouragement(worldIn, spreadPos = pos.func_177982_a(trySpreadX, trySpreadY, trySpreadZ))) <= 0) continue;
                        int spreadStrength = (adjacentEncouragement + 40 + worldIn.func_175659_aa().func_151525_a() * 7) / (age + 30);
                        if (feelsHumid) {
                            spreadStrength /= 2;
                        }
                        int n2 = spreadDifficulty = trySpreadY > 1 ? 100 + (trySpreadY - 1) * 100 : 100;
                        if (spreadStrength <= 0 || rand.nextInt(spreadDifficulty) > spreadStrength || !FireConfig.specialToggles.ignoreRain && worldIn.func_72896_J() && this.func_176537_d(worldIn, spreadPos)) continue;
                        if (FireConfig.spreadStrengths.naturalSpreadStrength == -1) {
                            childAge = age + rand.nextInt(5) / 4;
                            if (childAge > ControlledBurn.maxFireAge()) {
                                childAge = ControlledBurn.maxFireAge();
                            }
                            worldIn.func_180501_a(spreadPos, state.func_177226_a((IProperty)field_176543_a, (Comparable)Integer.valueOf(childAge)), 3);
                            continue;
                        }
                        if (FireConfig.spreadStrengths.naturalSpreadStrength == 0) continue;
                        childAge = age < 0 ? 0 : (age > ControlledBurn.maxFireAge() ? ControlledBurn.maxFireAge() : age);
                        childAge = ControlledBurn.maxFireAge() - (ControlledBurn.maxFireAge() - childAge) * FireConfig.spreadStrengths.naturalSpreadStrength / 100;
                        if (childAge >= ControlledBurn.maxFireAge()) continue;
                        worldIn.func_180501_a(spreadPos, state.func_177226_a((IProperty)field_176543_a, (Comparable)Integer.valueOf(childAge)), 3);
                    }
                }
            }
        }
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn) + rand.nextInt(10));
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return !(!worldIn.func_180495_p(pos.func_177977_b()).func_185896_q() && !this.canNeighborCatchFire(worldIn, pos) || FireConfig.specialToggles.noLightningFire && this.callerNameContains("Lightning"));
    }

    public boolean callerNameContains(String subString) {
        StackTraceElement[] stack;
        subString = subString.toLowerCase();
        for (StackTraceElement element : stack = Thread.currentThread().getStackTrace()) {
            if (!element.getClassName().toLowerCase().contains(subString)) continue;
            return true;
        }
        return false;
    }

    public int func_176532_c(Block blockIn) {
        int baseFlammability = super.func_176532_c(blockIn);
        if (FireConfig.globalMultipliers.burnSpeedMultiplier == 0.0) {
            if (baseFlammability > 0) {
                return 1;
            }
            if (baseFlammability < 0) {
                return -1;
            }
            return 0;
        }
        return (int)((double)baseFlammability * FireConfig.globalMultipliers.burnSpeedMultiplier);
    }

    public int func_176534_d(Block blockIn) {
        return (int)((double)super.func_176534_d(blockIn) * FireConfig.globalMultipliers.spreadSpeedMultiplier);
    }

    private void tryBurnAdjacent(World worldIn, BlockPos pos, int chance, Random random, int age, EnumFacing face) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        if (random.nextInt(chance) < iblockstate.func_177230_c().getFlammability((IBlockAccess)worldIn, pos, face)) {
            int replaceBlockWithFireChance = ControlledBurn.fireAgeRange() == 0 ? FireConfig.burnSpreadChances.minBurnSpreadChance + ControlledBurn.replaceBlockWithFireChanceRange / 2 : (int)((float)FireConfig.burnSpreadChances.minBurnSpreadChance + (float)ControlledBurn.replaceBlockWithFireChanceRange * (float)age / (float)ControlledBurn.fireAgeRange());
            if (!BlockFireEdit.tryBurnBlockSpecial(worldIn, pos)) {
                if (random.nextInt(100) < replaceBlockWithFireChance && (!worldIn.func_175727_C(pos) || FireConfig.specialToggles.ignoreRain)) {
                    if (FireConfig.spreadStrengths.burnSpreadStrength == -1) {
                        if (age < ControlledBurn.maxFireAge()) {
                            worldIn.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)field_176543_a, (Comparable)Integer.valueOf(random.nextInt(5) == 4 ? age + 1 : age)), 3);
                        } else {
                            worldIn.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)field_176543_a, (Comparable)Integer.valueOf(age)), 3);
                        }
                    } else if (FireConfig.spreadStrengths.burnSpreadStrength != 0) {
                        int childAge = ControlledBurn.maxFireAge() - (ControlledBurn.maxFireAge() - age) * FireConfig.spreadStrengths.burnSpreadStrength / 100;
                        if (childAge < ControlledBurn.maxFireAge()) {
                            worldIn.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)field_176543_a, (Comparable)Integer.valueOf(childAge)), 3);
                        } else if (FireConfig.spreadStrengths.burnSpreadStrength != 100) {
                            worldIn.func_175698_g(pos);
                        } else {
                            worldIn.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)field_176543_a, (Comparable)Integer.valueOf(age)), 3);
                        }
                    } else {
                        worldIn.func_175698_g(pos);
                    }
                } else {
                    worldIn.func_175698_g(pos);
                }
            }
            if (iblockstate.func_177230_c() == Blocks.field_150335_W) {
                Blocks.field_150335_W.func_176206_d(worldIn, pos, iblockstate.func_177226_a((IProperty)BlockTNT.field_176246_a, (Comparable)Boolean.valueOf(true)));
            }
        }
    }

    private boolean canNeighborCatchFire(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!this.canCatchFire((IBlockAccess)worldIn, pos.func_177972_a(enumfacing), enumfacing.func_176734_d())) continue;
            return true;
        }
        return false;
    }

    private int getNeighborEncouragement(World worldIn, BlockPos pos) {
        if (worldIn.func_175623_d(pos)) {
            int i = 0;
            for (EnumFacing enumfacing : EnumFacing.values()) {
                i = Math.max(worldIn.func_180495_p(pos.func_177972_a(enumfacing)).func_177230_c().getFireSpreadSpeed((IBlockAccess)worldIn, pos.func_177972_a(enumfacing), enumfacing.func_176734_d()), i);
            }
            return i;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        this.soundAndParticles(worldIn, pos, rand);
    }

    @SideOnly(value=Side.CLIENT)
    public void soundAndParticles(World worldIn, BlockPos pos, Random rand) {
        int i;
        double x = pos.func_177958_n();
        double y = pos.func_177956_o();
        double z = pos.func_177952_p();
        if (rand.nextInt(24) == 0) {
            worldIn.func_184134_a(x + 0.5, y + 0.5, z + 0.5, SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f + rand.nextFloat(), (float)(0.3 + 0.7 * (double)rand.nextFloat()), false);
        }
        if (worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) || this.func_176535_e((IBlockAccess)worldIn, pos.func_177977_b())) {
            for (int i2 = 0; i2 < 3; ++i2) {
                this.spawnSmokeParticle(worldIn, rand, x + rand.nextDouble(), y + 0.5 + 0.5 * rand.nextDouble(), z + rand.nextDouble());
            }
            return;
        }
        if (this.func_176535_e((IBlockAccess)worldIn, pos.func_177976_e())) {
            for (i = 0; i < 2; ++i) {
                this.spawnSmokeParticle(worldIn, rand, x + 0.1 * rand.nextDouble(), y + rand.nextDouble(), z + rand.nextDouble());
            }
        }
        if (this.func_176535_e((IBlockAccess)worldIn, pos.func_177974_f())) {
            for (i = 0; i < 2; ++i) {
                this.spawnSmokeParticle(worldIn, rand, x + 1.0 - 0.1 * rand.nextDouble(), y + rand.nextDouble(), z + rand.nextDouble());
            }
        }
        if (this.func_176535_e((IBlockAccess)worldIn, pos.func_177978_c())) {
            for (i = 0; i < 2; ++i) {
                this.spawnSmokeParticle(worldIn, rand, x + rand.nextDouble(), y + rand.nextDouble(), z + 0.1 * rand.nextDouble());
            }
        }
        if (this.func_176535_e((IBlockAccess)worldIn, pos.func_177968_d())) {
            for (i = 0; i < 2; ++i) {
                this.spawnSmokeParticle(worldIn, rand, x + rand.nextDouble(), y + rand.nextDouble(), z + 1.0 - 0.1 * rand.nextDouble());
            }
        }
        if (this.func_176535_e((IBlockAccess)worldIn, pos.func_177984_a())) {
            for (i = 0; i < 2; ++i) {
                this.spawnSmokeParticle(worldIn, rand, x + rand.nextDouble(), y + 1.0 - 0.1 * rand.nextDouble(), z + rand.nextDouble());
            }
        }
    }

    public void spawnSmokeParticle(World world, Random rand, double x, double y, double z) {
        world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, x, y, z, 0.0, 0.0, 0.0, new int[0]);
    }
}

