/*
 * Decompiled with CFR 0.152.
 */
package alexndr.plugins.SimpleOres;

import alexndr.api.core.SimpleCoreAPI;
import alexndr.api.helpers.game.OreGenerator;
import alexndr.api.logger.LogHelper;
import alexndr.api.registry.ContentRegistry;
import alexndr.api.registry.Plugin;
import alexndr.plugins.SimpleOres.Content;
import alexndr.plugins.SimpleOres.ModBlocks;
import alexndr.plugins.SimpleOres.ModItems;
import alexndr.plugins.SimpleOres.Settings;
import alexndr.plugins.SimpleOres.SimpleOres;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber
public class ProxyCommon {
    public void preInit(FMLPreInitializationEvent event) {
        ContentRegistry.registerPlugin((Plugin)SimpleOres.plugin);
        Settings.createOrLoadSettings(event);
        SimpleCoreAPI.tabPreInit();
        Content.preInitialize();
    }

    public void load(FMLInitializationEvent event) {
        ProxyCommon.setTabIcons();
        Content.setRepairMaterials();
        ProxyCommon.setOreGenSettings();
        Content.addSmeltingRecipes();
    }

    public void postInit(FMLPostInitializationEvent event) {
    }

    private static void setTabIcons() {
        LogHelper.verbose((String)"simpleores", (String)"Setting tab icons");
        ArrayList list = Lists.newArrayList((Object[])new Item[]{Item.func_150898_a((Block)ModBlocks.copper_ore), Item.func_150898_a((Block)ModBlocks.adamantium_block), ModItems.mythril_ingot, ModItems.onyx_pickaxe, ModItems.copper_sword, Item.func_150898_a((Block)Blocks.field_150460_al)});
        SimpleCoreAPI.setTabIcons((List)list);
    }

    private static void setOreGenSettings() {
        LogHelper.verbose((String)"simpleores", (String)"Setting ore gen parameters");
        if (Settings.copperOre.isEnableOreGen()) {
            OreGenerator.registerOreForGen((int)0, (Block)ModBlocks.copper_ore, (Block)Blocks.field_150348_b, (int)Settings.copperOre.getSpawnRate(), (int)Settings.copperOre.getVeinSize(), (int)Settings.copperOre.getMinHeight(), (int)Settings.copperOre.getMaxHeight());
        }
        if (Settings.tinOre.isEnableOreGen()) {
            OreGenerator.registerOreForGen((int)0, (Block)ModBlocks.tin_ore, (Block)Blocks.field_150348_b, (int)Settings.tinOre.getSpawnRate(), (int)Settings.tinOre.getVeinSize(), (int)Settings.tinOre.getMinHeight(), (int)Settings.tinOre.getMaxHeight());
        }
        if (Settings.mythrilOre.isEnableOreGen()) {
            OreGenerator.registerOreForGen((int)0, (Block)ModBlocks.mythril_ore, (Block)Blocks.field_150348_b, (int)Settings.mythrilOre.getSpawnRate(), (int)Settings.mythrilOre.getVeinSize(), (int)Settings.mythrilOre.getMinHeight(), (int)Settings.mythrilOre.getMaxHeight());
        }
        if (Settings.adamantiumOre.isEnableOreGen()) {
            OreGenerator.registerOreForGen((int)0, (Block)ModBlocks.adamantium_ore, (Block)Blocks.field_150348_b, (int)Settings.adamantiumOre.getSpawnRate(), (int)Settings.adamantiumOre.getVeinSize(), (int)Settings.adamantiumOre.getMinHeight(), (int)Settings.adamantiumOre.getMaxHeight());
        }
        if (Settings.onyxOre.isEnableOreGen()) {
            OreGenerator.registerOreForGen((int)-1, (Block)ModBlocks.onyx_ore, (Block)Blocks.field_150424_aL, (int)Settings.onyxOre.getSpawnRate(), (int)Settings.onyxOre.getVeinSize(), (int)Settings.onyxOre.getMinHeight(), (int)Settings.onyxOre.getMaxHeight());
        }
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        ModBlocks.register((IForgeRegistry<Block>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        ModItems.register((IForgeRegistry<Item>)event.getRegistry());
        ModBlocks.registerItemBlocks((IForgeRegistry<Item>)event.getRegistry());
        ModItems.registerOreDictionary();
        ModBlocks.registerOreDictionary();
    }

    public void registerItemRenderer(Plugin plugin, Item item, int meta, String id) {
    }
}

