/*
 * Decompiled with CFR 0.152.
 */
package alexndr.plugins.SimpleOres;

import alexndr.api.content.items.SimpleBucketType;
import alexndr.api.helpers.game.ArmorMaterialHelper;
import alexndr.api.logger.LogHelper;
import alexndr.plugins.SimpleOres.ModBlocks;
import alexndr.plugins.SimpleOres.ModItems;
import alexndr.plugins.SimpleOres.Settings;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class Content {
    public static SimpleBucketType copperBucketType;
    public static Item.ToolMaterial toolCopper;
    public static Item.ToolMaterial toolTin;
    public static Item.ToolMaterial toolMythril;
    public static Item.ToolMaterial toolAdamantium;
    public static Item.ToolMaterial toolOnyx;
    public static ItemArmor.ArmorMaterial armorCopper;
    public static ItemArmor.ArmorMaterial armorTin;
    public static ItemArmor.ArmorMaterial armorMythril;
    public static ItemArmor.ArmorMaterial armorAdamantium;
    public static ItemArmor.ArmorMaterial armorOnyx;

    public static void preInitialize() {
        Content.setToolAndArmorStats();
        Content.setBucketVariants();
        ModItems.configureSimpleItems();
        ModBlocks.configureBlocks();
        ModItems.configureTools();
        ModItems.configureBows();
        ModItems.configureArmor();
    }

    public static void setToolAndArmorStats() {
        LogHelper.verbose((String)"simpleores", (String)"Setting Tool and Armor stats");
        toolCopper = EnumHelper.addToolMaterial((String)"COPPER", (int)Settings.copperTools.getHarvestLevel(), (int)Settings.copperTools.getUses(), (float)Settings.copperTools.getHarvestSpeed(), (float)Settings.copperTools.getDamageVsEntity(), (int)Settings.copperTools.getEnchantability());
        toolTin = EnumHelper.addToolMaterial((String)"TIN", (int)Settings.tinTools.getHarvestLevel(), (int)Settings.tinTools.getUses(), (float)Settings.tinTools.getHarvestSpeed(), (float)Settings.tinTools.getDamageVsEntity(), (int)Settings.tinTools.getEnchantability());
        toolMythril = EnumHelper.addToolMaterial((String)"MYTHRIL", (int)Settings.mythrilTools.getHarvestLevel(), (int)Settings.mythrilTools.getUses(), (float)Settings.mythrilTools.getHarvestSpeed(), (float)Settings.mythrilTools.getDamageVsEntity(), (int)Settings.mythrilTools.getEnchantability());
        toolAdamantium = EnumHelper.addToolMaterial((String)"ADAMANTIUM", (int)Settings.adamantiumTools.getHarvestLevel(), (int)Settings.adamantiumTools.getUses(), (float)Settings.adamantiumTools.getHarvestSpeed(), (float)Settings.adamantiumTools.getDamageVsEntity(), (int)Settings.adamantiumTools.getEnchantability());
        toolOnyx = EnumHelper.addToolMaterial((String)"ONYX", (int)Settings.onyxTools.getHarvestLevel(), (int)Settings.onyxTools.getUses(), (float)Settings.onyxTools.getHarvestSpeed(), (float)Settings.onyxTools.getDamageVsEntity(), (int)Settings.onyxTools.getEnchantability());
        ResourceLocation soundName = new ResourceLocation("item.armor.equip_generic");
        SoundEvent armorNoise = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)soundName);
        armorCopper = EnumHelper.addArmorMaterial((String)"COPPER", (String)"copper", (int)Settings.copperArmor.getDurability(), (int[])new int[]{Settings.copperArmor.getBootsReduction(), Settings.copperArmor.getLegsReduction(), Settings.copperArmor.getChestReduction(), Settings.copperArmor.getHelmReduction()}, (int)Settings.copperArmor.getEnchantability(), (SoundEvent)armorNoise, (float)0.0f);
        armorTin = EnumHelper.addArmorMaterial((String)"TIN", (String)"tin", (int)Settings.tinArmor.getDurability(), (int[])new int[]{Settings.tinArmor.getBootsReduction(), Settings.tinArmor.getLegsReduction(), Settings.tinArmor.getChestReduction(), Settings.tinArmor.getHelmReduction()}, (int)Settings.tinArmor.getEnchantability(), (SoundEvent)armorNoise, (float)0.0f);
        armorMythril = EnumHelper.addArmorMaterial((String)"MYTHRIL", (String)"mythril", (int)Settings.mythrilArmor.getDurability(), (int[])new int[]{Settings.mythrilArmor.getBootsReduction(), Settings.mythrilArmor.getLegsReduction(), Settings.mythrilArmor.getChestReduction(), Settings.mythrilArmor.getHelmReduction()}, (int)Settings.mythrilArmor.getEnchantability(), (SoundEvent)armorNoise, (float)0.0f);
        armorAdamantium = EnumHelper.addArmorMaterial((String)"ADAMANTIUM", (String)"adamantium", (int)Settings.adamantiumArmor.getDurability(), (int[])new int[]{Settings.adamantiumArmor.getBootsReduction(), Settings.adamantiumArmor.getLegsReduction(), Settings.adamantiumArmor.getChestReduction(), Settings.adamantiumArmor.getHelmReduction()}, (int)Settings.adamantiumArmor.getEnchantability(), (SoundEvent)armorNoise, (float)1.0f);
        armorOnyx = EnumHelper.addArmorMaterial((String)"ONYX", (String)"onyx", (int)Settings.onyxArmor.getDurability(), (int[])new int[]{Settings.onyxArmor.getBootsReduction(), Settings.onyxArmor.getLegsReduction(), Settings.onyxArmor.getChestReduction(), Settings.onyxArmor.getHelmReduction()}, (int)Settings.onyxArmor.getEnchantability(), (SoundEvent)armorNoise, (float)2.0f);
    }

    public static void setRepairMaterials() {
        LogHelper.verbose((String)"simpleores", (String)"Setting Tool and Armor repair materials");
        if (Settings.copperIngot.isEnabled()) {
            if (toolCopper != null) {
                toolCopper.setRepairItem(new ItemStack((Item)ModItems.copper_ingot));
            }
            if (armorCopper != null) {
                ArmorMaterialHelper.setRepairItem((ItemArmor.ArmorMaterial)armorCopper, (ItemStack)new ItemStack((Item)ModItems.copper_ingot));
            }
        }
        if (Settings.tinIngot.isEnabled()) {
            if (toolTin != null) {
                toolTin.setRepairItem(new ItemStack((Item)ModItems.tin_ingot));
            }
            if (armorTin != null) {
                ArmorMaterialHelper.setRepairItem((ItemArmor.ArmorMaterial)armorTin, (ItemStack)new ItemStack((Item)ModItems.tin_ingot));
            }
        }
        if (Settings.mythrilIngot.isEnabled()) {
            if (toolMythril != null) {
                toolMythril.setRepairItem(new ItemStack((Item)ModItems.mythril_ingot));
            }
            if (armorMythril != null) {
                ArmorMaterialHelper.setRepairItem((ItemArmor.ArmorMaterial)armorMythril, (ItemStack)new ItemStack((Item)ModItems.mythril_ingot));
            }
        }
        if (Settings.adamantiumIngot.isEnabled()) {
            if (toolAdamantium != null) {
                toolAdamantium.setRepairItem(new ItemStack((Item)ModItems.adamantium_ingot));
            }
            if (armorAdamantium != null) {
                ArmorMaterialHelper.setRepairItem((ItemArmor.ArmorMaterial)armorAdamantium, (ItemStack)new ItemStack((Item)ModItems.adamantium_ingot));
            }
        }
        if (Settings.onyxGem.isEnabled()) {
            if (toolOnyx != null) {
                toolOnyx.setRepairItem(new ItemStack((Item)ModItems.onyx_gem));
            }
            if (armorOnyx != null) {
                ArmorMaterialHelper.setRepairItem((ItemArmor.ArmorMaterial)armorOnyx, (ItemStack)new ItemStack((Item)ModItems.onyx_gem));
            }
        }
    }

    public static void setBucketVariants() {
        LogHelper.verbose((String)"simpleores", (String)"Setting bucket variants");
        if (Settings.copperBucket.isEnabled()) {
            copperBucketType = new SimpleBucketType("copper");
            copperBucketType.setDestroyOnLava(true);
        }
        copperBucketType.addVariant("water", (Item)ModItems.copper_bucket_water, FluidRegistry.WATER);
    }

    public static void addSmeltingRecipes() {
        if (Settings.copperBucket.isEnabled() && Settings.copperIngot.isEnabled()) {
            GameRegistry.addSmelting((Item)ModItems.copper_bucket, (ItemStack)new ItemStack((Item)ModItems.copper_ingot, 3, 0), (float)0.0f);
        }
        if (Settings.copperIngot.isEnabled() && Settings.copperOre.isEnabled()) {
            GameRegistry.addSmelting((Block)ModBlocks.copper_ore, (ItemStack)new ItemStack((Item)ModItems.copper_ingot, 1, 0), (float)Settings.copperIngot.getSmeltingXP());
        }
        if (Settings.tinIngot.isEnabled() && Settings.tinOre.isEnabled()) {
            GameRegistry.addSmelting((Block)ModBlocks.tin_ore, (ItemStack)new ItemStack((Item)ModItems.tin_ingot, 1, 0), (float)Settings.tinIngot.getSmeltingXP());
        }
        if (Settings.mythrilIngot.isEnabled() && Settings.mythrilOre.isEnabled()) {
            GameRegistry.addSmelting((Block)ModBlocks.mythril_ore, (ItemStack)new ItemStack((Item)ModItems.mythril_ingot, 1, 0), (float)Settings.mythrilIngot.getSmeltingXP());
        }
        if (Settings.adamantiumIngot.isEnabled()) {
            GameRegistry.addSmelting((Block)ModBlocks.adamantium_ore, (ItemStack)new ItemStack((Item)ModItems.adamantium_ingot, 1, 0), (float)Settings.adamantiumIngot.getSmeltingXP());
        }
        if (Settings.onyxGem.isEnabled() && Settings.onyxOre.isEnabled()) {
            GameRegistry.addSmelting((Block)ModBlocks.onyx_ore, (ItemStack)new ItemStack((Item)ModItems.onyx_gem, 1, 0), (float)Settings.onyxGem.getSmeltingXP());
        }
    }
}

