/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings;

import greymerk.roguelike.dungeon.settings.ISpawnContext;
import greymerk.roguelike.worldgen.IPositionInfo;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class SpawnContext
implements ISpawnContext {
    private IPositionInfo info;

    public SpawnContext(IPositionInfo info) {
        this.info = info;
    }

    @Override
    public boolean biomeHasType(BiomeDictionary.Type type) {
        return BiomeDictionary.hasType((Biome)this.info.getBiome(), (BiomeDictionary.Type)type);
    }

    @Override
    public Biome getBiome() {
        return this.info.getBiome();
    }

    @Override
    public boolean includesBiome(List<ResourceLocation> biomeNames) {
        return biomeNames.contains(this.info.getBiome().getRegistryName());
    }

    @Override
    public boolean includesBiomeType(List<BiomeDictionary.Type> biomeTypes) {
        for (BiomeDictionary.Type type : biomeTypes) {
            if (!this.biomeHasType(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getDimension() {
        return this.info.getDimension();
    }
}

