/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.segment.part;

import greymerk.roguelike.dungeon.IDungeonLevel;
import greymerk.roguelike.dungeon.segment.part.SegmentBase;
import greymerk.roguelike.theme.ITheme;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IStair;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.blocks.BlockType;
import greymerk.roguelike.worldgen.shapes.RectHollow;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.util.Random;

public class SegmentFirePlace
extends SegmentBase {
    @Override
    protected void genWall(IWorldEditor editor, Random rand, IDungeonLevel level, Cardinal dir, ITheme theme, Coord origin) {
        MetaBlock air = BlockType.get(BlockType.AIR);
        IStair stair = theme.getSecondary().getStair();
        Coord cursor = new Coord(origin);
        Cardinal[] orth = Cardinal.orthogonal(dir);
        cursor.add(dir, 2);
        Coord start = new Coord(cursor);
        start.add(orth[0], 1);
        Coord end = new Coord(cursor);
        end.add(orth[1], 1);
        end.add(Cardinal.UP, 2);
        RectSolid.fill(editor, rand, start, end, air);
        start.add(dir, 1);
        end.add(dir, 1);
        RectSolid.fill(editor, rand, start, end, theme.getPrimary().getWall(), false, true);
        cursor.add(Cardinal.UP, 2);
        for (Cardinal d : orth) {
            Coord c = new Coord(cursor);
            c.add(d, 1);
            stair.setOrientation(Cardinal.reverse(d), true);
            stair.set(editor, c);
        }
        stair = theme.getPrimary().getStair();
        cursor = new Coord(origin);
        cursor.add(dir, 3);
        stair.setOrientation(Cardinal.reverse(dir), false);
        stair.set(editor, cursor);
        cursor.add(Cardinal.UP);
        BlockType.get(BlockType.IRON_BAR).set(editor, cursor);
        cursor.add(Cardinal.UP);
        stair.setOrientation(Cardinal.reverse(dir), true);
        stair.set(editor, cursor);
        start = new Coord(origin);
        start.add(dir, 4);
        end = new Coord(start);
        start.add(Cardinal.DOWN);
        start.add(orth[0]);
        end.add(Cardinal.UP, 3);
        end.add(orth[1]);
        end.add(dir, 2);
        for (Coord c : new RectHollow(start, end)) {
            if (editor.getBlock(c).func_185904_a().func_76220_a()) continue;
            return;
        }
        RectSolid.fill(editor, rand, start, end, theme.getPrimary().getWall());
        cursor = new Coord(origin);
        cursor.add(dir, 4);
        BlockType.get(BlockType.NETHERRACK).set(editor, cursor);
        cursor.add(Cardinal.UP);
        BlockType.get(BlockType.FIRE).set(editor, cursor);
    }
}

