/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.util.crafting.ingredient;

import com.google.common.collect.ImmutableList;
import com.pau101.fairylights.util.crafting.GenericRecipe;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public interface Ingredient<I extends Ingredient, M extends GenericRecipe.MatchResult<I, M>> {
    public ImmutableList<ItemStack> getInputs();

    default public ImmutableList<ImmutableList<ItemStack>> getInput(ItemStack output) {
        return ImmutableList.of(this.getInputs());
    }

    public M matches(ItemStack var1, ItemStack var2);

    default public boolean dictatesOutputType() {
        return false;
    }

    default public void present(ItemStack output) {
    }

    default public void absent(ItemStack output) {
    }

    default public ImmutableList<ItemStack> getMatchingSubtypes(ItemStack stack) {
        Objects.requireNonNull(stack, "stack");
        NonNullList subtypes = NonNullList.func_191196_a();
        Item item = stack.func_77973_b();
        for (CreativeTabs tab : item.getCreativeTabs()) {
            item.func_150895_a(tab, subtypes);
        }
        Iterator iter = subtypes.iterator();
        while (iter.hasNext()) {
            if (this.matches((ItemStack)iter.next(), ItemStack.field_190927_a).doesMatch()) continue;
            iter.remove();
        }
        return ImmutableList.copyOf((Collection)subtypes);
    }

    default public void addTooltip(List<String> tooltip) {
    }
}

