/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.server.fastener.connection.type.pennant;

import com.pau101.fairylights.client.gui.GuiEditLetteredConnection;
import com.pau101.fairylights.server.fastener.Fastener;
import com.pau101.fairylights.server.fastener.connection.ConnectionType;
import com.pau101.fairylights.server.fastener.connection.FeatureType;
import com.pau101.fairylights.server.fastener.connection.PlayerAction;
import com.pau101.fairylights.server.fastener.connection.collision.Intersection;
import com.pau101.fairylights.server.fastener.connection.type.ConnectionHangingFeature;
import com.pau101.fairylights.server.fastener.connection.type.Lettered;
import com.pau101.fairylights.server.fastener.connection.type.pennant.Pennant;
import com.pau101.fairylights.server.item.ItemLight;
import com.pau101.fairylights.server.sound.FLSounds;
import com.pau101.fairylights.util.OreDictUtils;
import com.pau101.fairylights.util.styledstring.StyledString;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class ConnectionPennantBunting
extends ConnectionHangingFeature<Pennant>
implements Lettered {
    private List<EnumDyeColor> pattern;
    private StyledString text;

    public ConnectionPennantBunting(World world, Fastener<?> fastener, UUID uuid, Fastener<?> destination, boolean isOrigin, NBTTagCompound compound) {
        super(world, fastener, uuid, destination, isOrigin, compound);
    }

    public ConnectionPennantBunting(World world, Fastener<?> fastener, UUID uuid) {
        super(world, fastener, uuid);
        this.pattern = new ArrayList<EnumDyeColor>();
        this.text = new StyledString();
    }

    @Override
    public float getRadius() {
        return 0.045f;
    }

    @Override
    public ConnectionType getType() {
        return ConnectionType.PENNANT_BUNTING;
    }

    @Override
    public void processClientAction(EntityPlayer player, PlayerAction action, Intersection intersection) {
        if (this.openTextGui(player, action, intersection)) {
            super.processClientAction(player, action, intersection);
        }
    }

    @Override
    public boolean interact(EntityPlayer player, Vec3d hit, FeatureType featureType, int feature, ItemStack heldStack, EnumHand hand) {
        EnumDyeColor color;
        int index;
        EnumDyeColor patternColor;
        if (featureType == FEATURE && OreDictUtils.isDye(heldStack) && (patternColor = this.pattern.get(index = feature % this.pattern.size())) != (color = EnumDyeColor.func_176766_a((int)OreDictUtils.getDyeMetadata(heldStack)))) {
            this.pattern.set(index, color);
            this.dataUpdateState = true;
            heldStack.func_190918_g(1);
            this.world.func_184148_a(null, hit.field_72450_a, hit.field_72448_b, hit.field_72449_c, FLSounds.FEATURE_COLOR_CHANGE, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return super.interact(player, hit, featureType, feature, heldStack, hand);
    }

    protected Pennant[] createFeatures(int length) {
        return new Pennant[length];
    }

    @Override
    protected Pennant createFeature(int index, Vec3d point, Vec3d rotation) {
        Pennant pennant = new Pennant(index, point, rotation);
        if (this.pattern.size() > 0) {
            pennant.setColor(ItemLight.getColorValue(this.pattern.get(index % this.pattern.size())));
        }
        return pennant;
    }

    @Override
    protected float getFeatureSpacing() {
        return 11.0f;
    }

    @Override
    public boolean isSuppportedText(StyledString text) {
        return text.length() <= ((Pennant[])this.features).length && Lettered.super.isSuppportedText(text);
    }

    @Override
    public void setText(StyledString text) {
        this.text = text;
        this.dataUpdateState = true;
    }

    @Override
    public StyledString getText() {
        return this.text;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen createTextGUI() {
        return new GuiEditLetteredConnection<ConnectionPennantBunting>(this);
    }

    @Override
    public NBTTagCompound serializeLogic() {
        NBTTagCompound compound = super.serializeLogic();
        NBTTagList patternList = new NBTTagList();
        for (EnumDyeColor color : this.pattern) {
            NBTTagCompound colorCompound = new NBTTagCompound();
            colorCompound.func_74774_a("color", (byte)color.func_176767_b());
            patternList.func_74742_a((NBTBase)colorCompound);
        }
        compound.func_74782_a("pattern", (NBTBase)patternList);
        compound.func_74782_a("text", (NBTBase)StyledString.serialize(this.text));
        return compound;
    }

    @Override
    public void deserializeLogic(NBTTagCompound compound) {
        super.deserializeLogic(compound);
        this.pattern = new ArrayList<EnumDyeColor>();
        NBTTagList patternList = compound.func_150295_c("pattern", 10);
        for (int i = 0; i < patternList.func_74745_c(); ++i) {
            NBTTagCompound colorCompound = patternList.func_150305_b(i);
            this.pattern.add(EnumDyeColor.func_176766_a((int)colorCompound.func_74771_c("color")));
        }
        this.text = StyledString.deserialize(compound.func_74775_l("text"));
    }
}

