/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.server.entity;

import com.pau101.fairylights.server.item.FLItems;
import com.pau101.fairylights.server.sound.FLSounds;
import com.pau101.fairylights.util.Utils;
import com.pau101.fairylights.util.matrix.MatrixStack;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public final class EntityLadder
extends EntityLivingBase
implements IEntityAdditionalSpawnData {
    private static final byte PUNCH_ID = 32;
    private long lastPunchTime;

    public EntityLadder(World world) {
        super(world);
        this.func_70105_a(1.15f, 2.8f);
    }

    public boolean func_70104_M() {
        return false;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(FLItems.LADDER);
    }

    public Iterable<ItemStack> func_184193_aE() {
        return Collections.EMPTY_LIST;
    }

    public ItemStack func_184582_a(EntityEquipmentSlot slot) {
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EntityEquipmentSlot slot, ItemStack stack) {
    }

    public EnumHandSide func_184591_cq() {
        return EnumHandSide.RIGHT;
    }

    protected SoundEvent func_184588_d(int distance) {
        return FLSounds.LADDER_FALL;
    }

    protected SoundEvent func_184601_bQ(DamageSource damage) {
        return FLSounds.LADDER_HIT;
    }

    protected SoundEvent func_184615_bR() {
        return FLSounds.LADDER_BREAK;
    }

    public boolean func_190631_cK() {
        return false;
    }

    public boolean func_184603_cC() {
        return false;
    }

    public List<AxisAlignedBB> getCollisionSurfaces() {
        MatrixStack mat = new MatrixStack();
        mat.rotate(-this.field_70177_z * ((float)Math.PI / 180) + (float)Math.PI, 0.0f, 1.0f, 0.0f);
        ArrayList<AxisAlignedBB> bounds = new ArrayList<AxisAlignedBB>();
        float[][] steps = new float[][]{{7.3f, -12.0f}, {16.3f, -9.7f}, {25.4f, -7.3f}, {34.3f, -4.9f}, {25.9f, 7.3f}};
        float bs = 3.67f;
        float bhm = 0.076458335f;
        float bvm = 0.0625f;
        for (float[] step : steps) {
            for (int b = -1; b <= 1; ++b) {
                Vec3d p = mat.transform(new Vec3d((double)((float)b * 3.67f), (double)step[0], (double)step[1])).func_186678_a(0.0625);
                bounds.add(new AxisAlignedBB(this.field_70165_t + p.field_72450_a - 0.07645833492279053, this.field_70163_u + p.field_72448_b - 0.0625, this.field_70161_v + p.field_72449_c - 0.07645833492279053, this.field_70165_t + p.field_72450_a + 0.07645833492279053, this.field_70163_u + p.field_72448_b + 0.0625, this.field_70161_v + p.field_72449_c + 0.07645833492279053));
            }
        }
        float tym = 2.71875f;
        float thm = 0.25f;
        bounds.add(new AxisAlignedBB(this.field_70165_t - 0.25, this.field_70163_u + 2.71875 - 0.0625, this.field_70161_v - 0.25, this.field_70165_t + 0.25, this.field_70163_u + 2.71875 + 0.0625, this.field_70161_v + 0.25));
        return bounds;
    }

    public String func_70005_c_() {
        return Utils.getEntityName((Entity)this);
    }

    public void func_70077_a(EntityLightningBolt bolt) {
    }

    public void func_70024_g(double x, double y, double z) {
    }

    public void func_70108_f(Entity entity) {
    }

    protected void func_85033_bc() {
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L || this.func_180431_b(source)) {
            return false;
        }
        if (DamageSource.field_76380_i == source) {
            this.func_70106_y();
        } else if (source.func_94541_c()) {
            this.playBreakSound();
            this.func_70106_y();
        } else if (DamageSource.field_76372_a == source) {
            if (this.func_70027_ad()) {
                this.damage(0.15f);
            } else {
                this.func_70015_d(5);
            }
        } else if (DamageSource.field_76370_b == source && this.func_110143_aJ() > 0.5f) {
            this.damage(4.0f);
        } else if (this.isPlayerDamage(source)) {
            if (source.func_180136_u()) {
                this.playBreakSound();
                this.playParticles();
                this.func_70106_y();
            } else {
                long time = this.field_70170_p.func_82737_E();
                if (time - this.lastPunchTime > 5L) {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)32);
                    this.lastPunchTime = time;
                } else {
                    this.dropIt();
                    this.playParticles();
                    this.func_70106_y();
                }
            }
        }
        return false;
    }

    private boolean isPlayerDamage(DamageSource source) {
        if ("player".equals(source.func_76355_l())) {
            Entity e = source.func_76346_g();
            return !(e instanceof EntityPlayer) || ((EntityPlayer)e).field_71075_bZ.field_75099_e;
        }
        return false;
    }

    private void dropIt() {
        Block.func_180635_a((World)this.field_70170_p, (BlockPos)new BlockPos((Entity)this), (ItemStack)new ItemStack(FLItems.LADDER));
    }

    private void playBreakSound() {
        this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.func_184615_bR(), this.func_184176_by(), 1.0f, 1.0f);
    }

    private void playParticles() {
        if (this.field_70170_p instanceof WorldServer) {
            ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.BLOCK_DUST, this.field_70165_t, this.field_70163_u + (double)this.field_70131_O / 1.5, this.field_70161_v, 18, (double)(this.field_70130_N / 4.0f), (double)(this.field_70131_O / 4.0f), (double)(this.field_70130_N / 4.0f), 0.05, new int[]{Block.func_176210_f((IBlockState)Blocks.field_150344_f.func_176223_P())});
        }
    }

    private void damage(float amount) {
        float newHealth = this.func_110143_aJ() - amount;
        if (newHealth <= 0.5f) {
            this.dropIt();
            this.func_70106_y();
        } else {
            this.func_70606_j(newHealth);
        }
    }

    public void func_70103_a(byte id) {
        if (id == 32) {
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, FLSounds.LADDER_HIT, this.func_184176_by(), 0.3f, 1.0f, false);
                this.lastPunchTime = this.field_70170_p.func_82737_E();
            }
        } else {
            super.func_70103_a(id);
        }
    }

    public void func_174812_G() {
        this.func_70106_y();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70761_aq = this.field_70759_as = this.field_70177_z;
    }

    public void writeSpawnData(ByteBuf buf) {
    }

    public void readSpawnData(ByteBuf buf) {
        this.field_70761_aq = this.field_70759_as = this.field_70177_z;
        this.field_70126_B = this.field_70759_as;
        this.field_70760_ar = this.field_70759_as;
    }
}

