/*
 * Decompiled with CFR 0.152.
 */
package naqaden.namepain.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import naqaden.namepain.NamePain;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.util.text.Style;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Config {
    private static ConfigCategory confCatOptions;
    private static String strCatOptions;
    public static Class<?> playerClass;
    public static boolean vanillaScoreboards;
    public static boolean vanillaMobs;
    private static final String labelR = "\u00a7cRed";
    private static final String labelG = "\u00a7aGreen";
    private static final String labelB = "\u00a79Blue";
    private static final String labelA = "\u00a77Alpha";
    private static ConfigCategory confCatNameMax;
    private static String strCatNameMax;
    public static int nameMaxR;
    public static int nameMaxG;
    public static int nameMaxB;
    public static int nameMaxA;
    public static float nameMaxV;
    private static ConfigCategory confCatNameMin;
    private static String strCatNameMin;
    public static int nameMinR;
    public static int nameMinG;
    public static int nameMinB;
    public static int nameMinA;
    public static float nameMinV;
    private static ConfigCategory confCatPlateMax;
    private static String strCatPlateMax;
    public static int plateMaxR;
    public static int plateMaxG;
    public static int plateMaxB;
    public static int plateMaxA;
    public static float plateMaxV;
    private static ConfigCategory confCatPlateMin;
    private static String strCatPlateMin;
    public static int plateMinR;
    public static int plateMinG;
    public static int plateMinB;
    public static int plateMinA;
    public static float plateMinV;
    private static ConfigCategory confCatSurprise;
    private static String strCatSurprise;
    public static boolean doAprilFools;
    public static Style obfuscated;

    public static void reload() {
        try {
            if (NamePain.config.hasChanged()) {
                NamePain.config.save();
            }
            NamePain.config.load();
            Config.initCategories();
        }
        catch (Exception ex) {
            System.out.println("Problem accessing " + NamePain.configFile.getAbsolutePath() + ":");
            ex.printStackTrace(System.out);
        }
        finally {
            if (NamePain.config.hasChanged()) {
                NamePain.config.save();
            }
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("namepain")) {
            Config.reload();
        }
    }

    public static void initCategories() {
        Config.catOptions();
        Config.catNameMax();
        Config.catNameMin();
        Config.catPlateMax();
        Config.catPlateMin();
        if (NamePain.isAprilFools) {
            Config.catSurprise();
        }
    }

    public static void catOptions() {
        confCatOptions = NamePain.config.getCategory(strCatOptions);
        confCatOptions.setComment("Toggles for features");
        vanillaMobs = NamePain.config.getBoolean("Vanilla Mobs", strCatOptions, vanillaMobs, "true: Keep normal coloring on named mobs.\nfalse: Apply Name Pain coloring to named mobs.");
        vanillaScoreboards = NamePain.config.getBoolean("Vanilla Scoreboards", strCatOptions, vanillaScoreboards, "true: Keep normal coloring on scoreboard objectives below player names.\nfalse: Apply Name Pain coloring to scoreboard objectives below player names.");
        playerClass = NamePain.config.getBoolean("Vanilla Self", strCatOptions, true, "true: Don't render your nameplate.\nfalse: Apply Name Pain coloring to your nameplate in inventory and 3rd-person view.") ? EntityOtherPlayerMP.class : AbstractClientPlayer.class;
        confCatOptions.setPropertyOrder(Arrays.asList("Vanilla Self", "Vanilla Scoreboards", "Vanilla Mobs"));
    }

    public static void catNameMax() {
        confCatNameMax = NamePain.config.getCategory(strCatNameMax);
        confCatNameMax.setComment("RGBA values for NAMES with MAXIMUM health");
        nameMaxR = NamePain.config.getInt(labelR, strCatNameMax, nameMaxR, 0, 255, "");
        nameMaxG = NamePain.config.getInt(labelG, strCatNameMax, nameMaxG, 0, 255, "");
        nameMaxB = NamePain.config.getInt(labelB, strCatNameMax, nameMaxB, 0, 255, "");
        nameMaxA = Math.round(NamePain.config.getFloat(labelA, strCatNameMax, 1.0f, 0.0f, 1.0f, "0 = transparent, 1 = opaque") * 255.0f);
        nameMaxV = Config.getVibrancy(nameMaxR, nameMaxG, nameMaxB);
        confCatNameMax.setPropertyOrder(Arrays.asList(labelR, labelG, labelB, labelA));
        for (Property prop : confCatNameMax.getOrderedValues()) {
            prop.setConfigEntryClass(GuiConfigEntries.NumberSliderEntry.class);
        }
    }

    public static void catNameMin() {
        confCatNameMin = NamePain.config.getCategory(strCatNameMin);
        confCatNameMin.setComment("RGBA values for NAMES with MINIMUM health");
        nameMinR = NamePain.config.getInt(labelR, strCatNameMin, nameMinR, 0, 255, "");
        nameMinG = NamePain.config.getInt(labelG, strCatNameMin, nameMinG, 0, 255, "");
        nameMinB = NamePain.config.getInt(labelB, strCatNameMin, nameMinB, 0, 255, "");
        nameMinA = Math.round(NamePain.config.getFloat(labelA, strCatNameMin, 1.0f, 0.0f, 1.0f, "0 = transparent, 1 = opaque") * 255.0f);
        nameMinV = Config.getVibrancy(nameMinR, nameMinG, nameMinB);
        confCatNameMin.setPropertyOrder(Arrays.asList(labelR, labelG, labelB, labelA));
        for (Property prop : confCatNameMin.getOrderedValues()) {
            prop.setConfigEntryClass(GuiConfigEntries.NumberSliderEntry.class);
        }
    }

    public static void catPlateMax() {
        confCatPlateMax = NamePain.config.getCategory(strCatPlateMax);
        confCatPlateMax.setComment("RGBA values for BACKGROUNDS with MAXIMUM health");
        plateMaxR = NamePain.config.getInt(labelR, strCatPlateMax, plateMaxR, 0, 255, "");
        plateMaxG = NamePain.config.getInt(labelG, strCatPlateMax, plateMaxG, 0, 255, "");
        plateMaxB = NamePain.config.getInt(labelB, strCatPlateMax, plateMaxB, 0, 255, "");
        plateMaxA = Math.round(NamePain.config.getFloat(labelA, strCatPlateMax, 0.25f, 0.0f, 1.0f, "0 = transparent, 1 = opaque") * 255.0f);
        plateMaxV = Config.getVibrancy(plateMaxR, plateMaxG, plateMaxB);
        confCatPlateMax.setPropertyOrder(Arrays.asList(labelR, labelG, labelB, labelA));
        for (Property prop : confCatPlateMax.getOrderedValues()) {
            prop.setConfigEntryClass(GuiConfigEntries.NumberSliderEntry.class);
        }
    }

    public static void catPlateMin() {
        confCatPlateMin = NamePain.config.getCategory(strCatPlateMin);
        confCatPlateMin.setComment("RGBA values for BACKGROUNDS with MINIMUM health");
        plateMinR = NamePain.config.getInt(labelR, strCatPlateMin, plateMinR, 0, 255, "");
        plateMinG = NamePain.config.getInt(labelG, strCatPlateMin, plateMinG, 0, 255, "");
        plateMinB = NamePain.config.getInt(labelB, strCatPlateMin, plateMinB, 0, 255, "");
        plateMinA = Math.round(NamePain.config.getFloat(labelA, strCatPlateMin, 0.25f, 0.0f, 1.0f, "0 = transparent, 1 = opaque") * 255.0f);
        plateMinV = Config.getVibrancy(plateMinR, plateMinG, plateMinB);
        confCatPlateMin.setPropertyOrder(Arrays.asList(labelR, labelG, labelB, labelA));
        for (Property prop : confCatPlateMin.getOrderedValues()) {
            prop.setConfigEntryClass(GuiConfigEntries.NumberSliderEntry.class);
        }
    }

    public static void catSurprise() {
        confCatSurprise = NamePain.config.getCategory(strCatSurprise);
        doAprilFools = NamePain.config.getBoolean("April Fools!", strCatSurprise, doAprilFools, "true: Let it happen.\nfalse: Stop this nonsense.");
    }

    public static List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> configElements = new ArrayList<IConfigElement>();
        configElements.add((IConfigElement)new ConfigElement(confCatOptions));
        configElements.add((IConfigElement)new ConfigElement(confCatNameMax));
        configElements.add((IConfigElement)new ConfigElement(confCatNameMin));
        configElements.add((IConfigElement)new ConfigElement(confCatPlateMax));
        configElements.add((IConfigElement)new ConfigElement(confCatPlateMin));
        if (NamePain.isAprilFools) {
            configElements.add((IConfigElement)new ConfigElement(confCatSurprise));
        }
        return configElements;
    }

    public static float getVibrancy(int R, int G, int B) {
        if (R >= G && R >= B) {
            return R;
        }
        if (G >= B) {
            return G;
        }
        return B;
    }

    public static float getVibrancy(float R, float G, float B) {
        if (R >= G && R >= B) {
            return R;
        }
        if (G >= B) {
            return G;
        }
        return B;
    }

    static {
        strCatOptions = "Settings";
        playerClass = EntityOtherPlayerMP.class;
        vanillaScoreboards = true;
        vanillaMobs = false;
        strCatNameMax = "Name Color @ Max Health";
        nameMaxR = 255;
        nameMaxG = 255;
        nameMaxB = 255;
        nameMaxA = 255;
        nameMaxV = 255.0f;
        strCatNameMin = "Name Color @ Min Health";
        nameMinR = 255;
        nameMinG = 0;
        nameMinB = 0;
        nameMinA = 255;
        nameMinV = 255.0f;
        strCatPlateMax = "Plate Color @ Max Health";
        plateMaxR = 0;
        plateMaxG = 0;
        plateMaxB = 0;
        plateMaxA = 32;
        plateMaxV = 0.0f;
        strCatPlateMin = "Plate Color @ Min Health";
        plateMinR = 0;
        plateMinG = 0;
        plateMinB = 0;
        plateMinA = 32;
        plateMinV = 0.0f;
        strCatSurprise = "?";
        doAprilFools = NamePain.isAprilFools;
        obfuscated = new Style().func_150237_e(Boolean.valueOf(true));
    }
}

